/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import java.io.PrintStream;
import org.ejml.EjmlParameters;
import org.ejml.data.Matrix64F;
import org.ejml.data.ReshapeMatrix64F;
import org.ejml.ops.MatrixIO;

public class BlockD3Matrix64F
extends ReshapeMatrix64F {
    public int blockLength;
    public double[][][] blocks;

    public BlockD3Matrix64F(int numRows, int numCols, int blockLength) {
        this.blockLength = blockLength;
        this.reshape(numRows, numCols, false);
    }

    public BlockD3Matrix64F(int numRows, int numCols) {
        this(numRows, numCols, EjmlParameters.BLOCK_WIDTH);
    }

    public double[][][] getData() {
        return this.blocks;
    }

    public void reshape(int numRows, int numCols, boolean saveValues) {
        this.numRows = numRows;
        this.numCols = numCols;
        int blockM = numRows / this.blockLength;
        int blockN = numCols / this.blockLength;
        if (numRows % this.blockLength > 0) {
            ++blockM;
        }
        if (numCols % this.blockLength > 0) {
            ++blockN;
        }
        this.blocks = new double[blockM][blockN][];
        for (int i = 0; i < numRows; i += this.blockLength) {
            int ii = i / this.blockLength;
            for (int j = 0; j < numCols; j += this.blockLength) {
                int jj = j / this.blockLength;
                this.blocks[ii][jj] = new double[this.blockLength * this.blockLength];
            }
        }
    }

    public double get(int row, int col) {
        int blockM = row / this.blockLength;
        int blockN = col / this.blockLength;
        int m = row % this.blockLength;
        int n = col % this.blockLength;
        int index = m * this.blockLength + n;
        return this.blocks[blockM][blockN][index];
    }

    public void set(int row, int col, double val) {
        int blockM = row / this.blockLength;
        int blockN = col / this.blockLength;
        int m = row % this.blockLength;
        int n = col % this.blockLength;
        int index = m * this.blockLength + n;
        this.blocks[blockM][blockN][index] = val;
    }

    public double unsafe_get(int row, int col) {
        return this.get(row, col);
    }

    public void unsafe_set(int row, int col, double val) {
        this.set(row, col, val);
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public int getNumElements() {
        return this.numRows * this.numCols;
    }

    public void print() {
        MatrixIO.print((PrintStream)System.out, (Matrix64F)this);
    }

    public <T extends Matrix64F> T copy() {
        return null;
    }
}

