/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.datastructure;

import com.googlecode.javaewah.IntIterator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;

public class BitSet
implements Cloneable,
Iterable<Integer>,
Externalizable {
    private long[] data;
    static final long serialVersionUID = 7997698588986878753L;

    public BitSet(int sizeInBits) {
        this.data = new long[(sizeInBits + 63) / 64];
    }

    public void and(BitSet bs) {
        for (int k = 0; k < Math.min(this.data.length, bs.data.length); ++k) {
            int n = k;
            this.data[n] = this.data[n] & bs.data[k];
        }
    }

    public int andcardinality(BitSet bs) {
        int sum = 0;
        for (int k = 0; k < Math.min(this.data.length, bs.data.length); ++k) {
            sum += Long.bitCount(this.data[k] & bs.data[k]);
        }
        return sum;
    }

    public void andNot(BitSet bs) {
        for (int k = 0; k < Math.min(this.data.length, bs.data.length); ++k) {
            int n = k;
            this.data[n] = this.data[n] & (bs.data[k] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public int andNotcardinality(BitSet bs) {
        int sum = 0;
        for (int k = 0; k < Math.min(this.data.length, bs.data.length); ++k) {
            sum += Long.bitCount(this.data[k] & (bs.data[k] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return sum;
    }

    public int cardinality() {
        int sum = 0;
        for (long l : this.data) {
            sum += Long.bitCount(l);
        }
        return sum;
    }

    public void clear() {
        Arrays.fill(this.data, 0L);
    }

    public BitSet clone() throws CloneNotSupportedException {
        try {
            BitSet b = (BitSet)super.clone();
            b.data = Arrays.copyOf(this.data, this.data.length);
            return b;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitSet)) {
            return false;
        }
        BitSet bs = (BitSet)o;
        for (int k = 0; k < Math.min(this.data.length, bs.data.length); ++k) {
            if (this.data[k] == bs.data[k]) continue;
            return false;
        }
        BitSet longer = bs.size() < this.size() ? this : bs;
        for (int k = Math.min(this.data.length, bs.data.length); k < Math.max(this.data.length, bs.data.length); ++k) {
            if (longer.data[k] == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean empty() {
        for (long l : this.data) {
            if (l == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean get(int i) {
        return (this.data[i / 64] & 1L << i % 64) != 0L;
    }

    public int hashCode() {
        int b = 31;
        int hash1 = 0;
        int hash2 = 0;
        for (long aData : this.data) {
            if (aData == 0L) continue;
            hash1 = hash1 * b + (int)aData;
            hash2 = hash2 * b + (int)(aData >>> 32);
        }
        return hash1 ^ hash2;
    }

    public IntIterator intIterator() {
        return new IntIterator(){
            private int i;
            private int j;
            {
                this.i = BitSet.this.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public int next() {
                this.j = this.i;
                this.i = BitSet.this.nextSetBit(this.i + 1);
                return this.j;
            }
        };
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int i;
            private int j;
            {
                this.i = BitSet.this.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public Integer next() {
                this.j = this.i;
                this.i = BitSet.this.nextSetBit(this.i + 1);
                return this.j;
            }

            @Override
            public void remove() {
                BitSet.this.unset(this.j);
            }
        };
    }

    public boolean intersects(BitSet bs) {
        for (int k = 0; k < Math.min(this.data.length, bs.data.length); ++k) {
            if ((this.data[k] & bs.data[k]) == 0L) continue;
            return true;
        }
        return false;
    }

    public int nextSetBit(int i) {
        int x = i / 64;
        if (x >= this.data.length) {
            return -1;
        }
        long w = this.data[x];
        if ((w >>>= i % 64) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.data.length) {
            if (this.data[x] != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(this.data[x]);
            }
            ++x;
        }
        return -1;
    }

    public int nextUnsetBit(int i) {
        int x = i / 64;
        if (x >= this.data.length) {
            return -1;
        }
        long w = this.data[x] ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w >>>= i % 64) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.data.length) {
            if (this.data[x] != -1L) {
                return x * 64 + Long.numberOfTrailingZeros(this.data[x] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++x;
        }
        return -1;
    }

    public void or(BitSet bs) {
        if (this.size() < bs.size()) {
            this.resize(bs.size());
        }
        for (int k = 0; k < this.data.length; ++k) {
            int n = k;
            this.data[n] = this.data[n] | bs.data[k];
        }
    }

    public int orcardinality(BitSet bs) {
        int sum = 0;
        for (int k = 0; k < Math.min(this.data.length, bs.data.length); ++k) {
            sum += Long.bitCount(this.data[k] | bs.data[k]);
        }
        BitSet longer = bs.size() < this.size() ? this : bs;
        for (int k = Math.min(this.data.length, bs.data.length); k < Math.max(this.data.length, bs.data.length); ++k) {
            sum += Long.bitCount(longer.data[k]);
        }
        return sum;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        this.data = new long[length];
        for (int k = 0; k < length; ++k) {
            this.data[k] = in.readLong();
        }
    }

    public void resize(int sizeInBits) {
        this.data = Arrays.copyOf(this.data, (sizeInBits + 63) / 64);
    }

    public void set(int i) {
        int n = i / 64;
        this.data[n] = this.data[n] | 1L << i % 64;
    }

    public void set(int i, boolean b) {
        if (b) {
            this.set(i);
        } else {
            this.unset(i);
        }
    }

    public int size() {
        return this.data.length * 64;
    }

    public void trim() {
        for (int k = this.data.length - 1; k >= 0; --k) {
            if (this.data[k] == 0L) continue;
            if (k + 1 < this.data.length) {
                this.data = Arrays.copyOf(this.data, k + 1);
            }
            return;
        }
        this.data = new long[0];
    }

    public void unset(int i) {
        int n = i / 64;
        this.data[n] = this.data[n] & (1L << i % 64 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public IntIterator unsetIntIterator() {
        return new IntIterator(){
            private int i;
            private int j;
            {
                this.i = BitSet.this.nextUnsetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public int next() {
                this.j = this.i;
                this.i = BitSet.this.nextUnsetBit(this.i + 1);
                return this.j;
            }
        };
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.data.length);
        for (long w : this.data) {
            out.writeLong(w);
        }
    }

    public void xor(BitSet bs) {
        if (this.size() < bs.size()) {
            this.resize(bs.size());
        }
        for (int k = 0; k < this.data.length; ++k) {
            int n = k;
            this.data[n] = this.data[n] ^ bs.data[k];
        }
    }

    public int xorcardinality(BitSet bs) {
        int sum = 0;
        for (int k = 0; k < Math.min(this.data.length, bs.data.length); ++k) {
            sum += Long.bitCount(this.data[k] ^ bs.data[k]);
        }
        BitSet longer = bs.size() < this.size() ? this : bs;
        int start = Math.min(this.data.length, bs.data.length);
        int end = Math.max(this.data.length, bs.data.length);
        for (int k = start; k < end; ++k) {
            sum += Long.bitCount(longer.data[k]);
        }
        return sum;
    }
}

