/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.RunningLengthWord;

final class ClearIntIterator
implements IntIterator {
    private final EWAHIterator ewahIter;
    private final int sizeinbits;
    private final long[] ewahBuffer;
    private int position;
    private int runningLength;
    private long word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasnext;

    ClearIntIterator(EWAHIterator ewahIter, int sizeinbits) {
        this.ewahIter = ewahIter;
        this.sizeinbits = sizeinbits;
        this.ewahBuffer = ewahIter.buffer();
        this.hasnext = this.moveToNext();
    }

    public final boolean moveToNext() {
        while (!this.runningHasNext() && !this.literalHasNext()) {
            if (!this.ewahIter.hasNext()) {
                return false;
            }
            this.setRunningLengthWord(this.ewahIter.next());
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.hasnext;
    }

    @Override
    public final int next() {
        int answer;
        if (this.runningHasNext()) {
            answer = this.position++;
        } else {
            long T = this.word & -this.word;
            answer = this.literalPosition + Long.bitCount(T - 1L);
            this.word ^= T;
        }
        this.hasnext = this.moveToNext();
        return answer;
    }

    private final void setRunningLengthWord(RunningLengthWord rlw) {
        this.runningLength = 64 * (int)rlw.getRunningLength() + this.position;
        if (rlw.getRunningBit()) {
            this.position = this.runningLength;
        }
        this.wordPosition = this.ewahIter.literalWords();
        this.wordLength = this.wordPosition + rlw.getNumberOfLiteralWords();
    }

    private final boolean runningHasNext() {
        return this.position < this.runningLength;
    }

    private final boolean literalHasNext() {
        while (this.word == 0L && this.wordPosition < this.wordLength) {
            int usedbitsinlast;
            this.word = this.ewahBuffer[this.wordPosition++] ^ 0xFFFFFFFFFFFFFFFFL;
            if (this.wordPosition == this.wordLength && !this.ewahIter.hasNext() && (usedbitsinlast = this.sizeinbits % 64) > 0) {
                this.word &= -1L >>> 64 - usedbitsinlast;
            }
            this.literalPosition = this.position;
            this.position += 64;
        }
        return this.word != 0L;
    }
}

