/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServerOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeFunctions;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OAuthTokenExtractor {
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    private static final String DUMMY_REQUEST = "http://127.0.0.1:80/this_is_a_bad_request_that_will_not_be_really_executed";
    final ServerOAuth2AuthorizedClientExchangeFilterFunction serverOAuth2AuthorizedClientExchangeFilterFunction;
    OAuthTokenFilter oAuthTokenFilter;
    ExchangeFunction getOAuthTokenExchangeFunction;
    ClientRequest dummyHttpRequest;

    public OAuthTokenExtractor(ServerOAuth2AuthorizedClientExchangeFilterFunction serverOAuth2AuthorizedClientExchangeFilterFunction) {
        if (serverOAuth2AuthorizedClientExchangeFilterFunction == null) {
            throw new NullPointerException("[internal error] serverOAuth2AuthorizedClientExchangeFilterFunction may not be null");
        }
        this.serverOAuth2AuthorizedClientExchangeFilterFunction = serverOAuth2AuthorizedClientExchangeFilterFunction;
        this.oAuthTokenFilter = new OAuthTokenFilter();
        this.getOAuthTokenExchangeFunction = ExchangeFunctions.create((ClientHttpConnector)new ReactorClientHttpConnector()).filter((ExchangeFilterFunction)this.oAuthTokenFilter).filter((ExchangeFilterFunction)serverOAuth2AuthorizedClientExchangeFilterFunction);
        try {
            this.dummyHttpRequest = ClientRequest.create((HttpMethod)HttpMethod.GET, (URI)new URI(DUMMY_REQUEST)).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public synchronized String getAuthorizationHeaderValue() {
        return (String)this.getOAuthTokenExchangeFunction.exchange(this.dummyHttpRequest).map(response -> (String)response.bodyToMono(String.class).block()).block();
    }

    public static class OAuthTokenFilter
    implements ExchangeFilterFunction {
        public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
            String url = request.url().toString();
            if (!url.equals(OAuthTokenExtractor.DUMMY_REQUEST)) {
                return next.exchange(request);
            }
            List headers = request.headers().get((Object)OAuthTokenExtractor.AUTHORIZATION_HEADER_NAME);
            String authorizationHeaderValue = null;
            if (headers == null || headers.size() == 0) {
                System.out.println("WARNING:No Authorization header found, when exactly 1 is expected");
            } else if (headers.size() > 1) {
                System.out.println("WARNING:Found " + headers.size() + " Authorization headers, when exactly 1 is expected");
            } else {
                authorizationHeaderValue = (String)headers.get(0);
            }
            return Mono.just((Object)new GetOAuthTokenClientResponse(authorizationHeaderValue));
        }
    }

    public static class GetOAuthTokenClientResponse
    implements ClientResponse {
        private final String authorizationHeader;

        public GetOAuthTokenClientResponse(String authorizationHeader) {
            this.authorizationHeader = authorizationHeader;
        }

        public HttpStatus statusCode() {
            return HttpStatus.OK;
        }

        public int rawStatusCode() {
            return 200;
        }

        public ClientResponse.Headers headers() {
            return new ClientResponse.Headers(){

                public List<String> header(String headerName) {
                    ArrayList<String> ret = new ArrayList<String>();
                    if (OAuthTokenExtractor.AUTHORIZATION_HEADER_NAME.equals(headerName)) {
                        ret.add(authorizationHeader);
                    }
                    return ret;
                }

                public Optional<MediaType> contentType() {
                    return Optional.of(null);
                }

                public OptionalLong contentLength() {
                    return OptionalLong.of(0L);
                }

                public HttpHeaders asHttpHeaders() {
                    return null;
                }
            };
        }

        public MultiValueMap<String, ResponseCookie> cookies() {
            return null;
        }

        public ExchangeStrategies strategies() {
            return null;
        }

        public <T> T body(BodyExtractor<T, ? super ClientHttpResponse> extractor) {
            return null;
        }

        public <T> Mono<T> bodyToMono(Class<? extends T> elementClass) {
            if (elementClass == String.class) {
                return Mono.just((Object)(this.authorizationHeader == null ? "" : this.authorizationHeader));
            }
            throw new IllegalArgumentException("Only String class is allowed, for " + this.getClass().getSimpleName() + "'s body, but a " + elementClass.getName() + " was requested");
        }

        public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> elementTypeRef) {
            throw new RuntimeException("Not Implemented");
        }

        public <T> Flux<T> bodyToFlux(Class<? extends T> elementClass) {
            throw new RuntimeException("Not Implemented");
        }

        public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> elementTypeRef) {
            throw new RuntimeException("Not Implemented");
        }

        public Mono<Void> releaseBody() {
            throw new RuntimeException("Not Implemented");
        }

        public <T> Mono<ResponseEntity<T>> toEntity(Class<T> bodyClass) {
            throw new RuntimeException("Not Implemented");
        }

        public <T> Mono<ResponseEntity<T>> toEntity(ParameterizedTypeReference<T> bodyTypeReference) {
            throw new RuntimeException("Not Implemented");
        }

        public <T> Mono<ResponseEntity<List<T>>> toEntityList(Class<T> elementClass) {
            throw new RuntimeException("Not Implemented");
        }

        public <T> Mono<ResponseEntity<List<T>>> toEntityList(ParameterizedTypeReference<T> elementTypeRef) {
            throw new RuntimeException("Not Implemented");
        }

        public Mono<ResponseEntity<Void>> toBodilessEntity() {
            throw new RuntimeException("Not Implemented");
        }

        public Mono<WebClientResponseException> createException() {
            throw new RuntimeException("Not Implemented");
        }

        public String logPrefix() {
            return this.getClass().getSimpleName();
        }

        public <T> Mono<T> createError() {
            return null;
        }

        public HttpRequest request() {
            return null;
        }
    }
}

