/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.graphql_java_generator.client.CustomScalarRegistry;
import com.graphql_java_generator.customscalars.CustomScalar;
import graphql.schema.GraphQLScalarType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class CustomScalarRegistryImpl
implements CustomScalarRegistry {
    @Autowired
    ApplicationContext ctx;
    private static Map<String, CustomScalarRegistry> customScalarRegistries = new HashMap<String, CustomScalarRegistry>();
    Map<String, CustomScalar> customScalarTypes = new HashMap<String, CustomScalar>();

    public static void registerCustomScalarRegistry(String schema, Consumer<CustomScalarRegistry> customScalarRegistryInitializer) {
        if (customScalarRegistries.containsKey(schema)) {
            throw new IllegalArgumentException("The CustomScalarRegistry for the '" + schema + "' schema has already been defined");
        }
        CustomScalarRegistryImpl customScalarRegistry = new CustomScalarRegistryImpl();
        customScalarRegistryInitializer.accept(customScalarRegistry);
        customScalarRegistries.put(schema, customScalarRegistry);
    }

    public static GraphQLScalarType getGraphQLCustomScalarType(String schema, String graphQLTypeName) {
        return customScalarRegistries.get(schema).getGraphQLCustomScalarType(graphQLTypeName);
    }

    public static CustomScalar getCustomScalar(String schema, String graphQLTypeName) {
        return customScalarRegistries.get(schema).getCustomScalar(graphQLTypeName);
    }

    @Override
    public void registerGraphQLScalarType(String typeName, GraphQLScalarType type, Class<?> valueClazz) {
        this.customScalarTypes.put(typeName, new CustomScalar(GraphQLScalarType.newScalar((GraphQLScalarType)type).name(typeName).build(), valueClazz));
    }

    @Override
    public GraphQLScalarType getGraphQLCustomScalarType(String graphQLTypeName) {
        CustomScalar scalar = this.customScalarTypes.get(graphQLTypeName);
        return scalar == null ? null : scalar.getGraphQLScalarType();
    }

    @Override
    public CustomScalar getCustomScalar(String graphQLTypeName) {
        return this.customScalarTypes.get(graphQLTypeName);
    }
}

