/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.sdk.common;

import com.groupdocs.sdk.common.ApiInvoker;
import com.sun.jersey.multipart.file.DefaultMediaTypePredictor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.IOUtils;

public class MimeUtils {
    private static final Map<String, String> mimeTab = new HashMap<String, String>();
    private static final Map<String, String> extensionMap = new HashMap<String, String>();

    public static String getMimeTypeFor(String filenameOrExtension) {
        if (filenameOrExtension == null) {
            return null;
        }
        String ext = filenameOrExtension.contains(".") ? filenameOrExtension.substring(filenameOrExtension.lastIndexOf(46) + 1) : filenameOrExtension;
        return mimeTab.get(ext.toLowerCase());
    }

    public static String getExtensionFor(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        return extensionMap.get(mimeType.toLowerCase());
    }

    public static void registerMimeType(String mimeType, String ... extensions) {
        if (mimeType == null || mimeType.length() == 0 || extensions == null || extensions.length == 0) {
            return;
        }
        mimeType = mimeType.toLowerCase();
        String defaultExtension = extensionMap.get(mimeType);
        for (String extension : extensions) {
            if (extension == null || extension.length() <= 0) continue;
            extension = extension.toLowerCase();
            mimeTab.put(extension, mimeType);
            if (defaultExtension != null) continue;
            defaultExtension = extension;
        }
        if (defaultExtension != null) {
            extensionMap.put(mimeType, defaultExtension);
        }
    }

    public static void registerMimeTypes(InputStream is) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
        while ((line = br.readLine()) != null) {
            String[] parts;
            if (line.startsWith("#") || (parts = line.split("\\s+")).length <= 1) continue;
            String[] extensions = new String[parts.length - 1];
            System.arraycopy(parts, 1, extensions, 0, extensions.length);
            MimeUtils.registerMimeType(parts[0], extensions);
        }
    }

    public static String readAsDataURL(File file) throws IOException {
        String mimeType = MimeUtils.getMimeTypeFor(file.getName());
        if (mimeType == null) {
            mimeType = new DefaultMediaTypePredictor().getMediaTypeFromFile(file).toString();
        }
        return MimeUtils.readAsDataURL(file, mimeType);
    }

    public static String readAsDataURL(File file, String contentType) throws IOException {
        return MimeUtils.readAsDataURL(new FileInputStream(file), contentType);
    }

    public static String readAsDataURL(InputStream is, String contentType) throws IOException {
        String base64file = IOUtils.toString((InputStream)new Base64InputStream(is, true, 0, null));
        return "data:" + contentType + ";base64," + base64file;
    }

    static {
        try {
            MimeUtils.registerMimeTypes(ApiInvoker.class.getResourceAsStream("/META-INF/mime.types"));
        }
        catch (IOException e) {
            System.err.println("Failed to read mime.types file");
        }
    }
}

