/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.model.http.useragent;

import com.litongjava.model.http.useragent.UserAgentInfo;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserAgentBrowser
extends UserAgentInfo {
    private static final long serialVersionUID = 6844785189881450545L;
    public static final UserAgentBrowser Unknown = new UserAgentBrowser("Unknown", null, null);
    public static final String Other_Version = "[\\/ ]([\\d\\w\\.\\-]+)";
    public static final List<UserAgentBrowser> browers = Arrays.asList(new UserAgentBrowser("MSEdge", "Edge", "edge\\/([\\d\\w\\.\\-]+)"), new UserAgentBrowser("Chrome", "chrome", "chrome\\/([\\d\\w\\.\\-]+)"), new UserAgentBrowser("Firefox", "firefox", "[\\/ ]([\\d\\w\\.\\-]+)"), new UserAgentBrowser("IEMobile", "iemobile", "[\\/ ]([\\d\\w\\.\\-]+)"), new UserAgentBrowser("Safari", "safari", "version\\/([\\d\\w\\.\\-]+)"), new UserAgentBrowser("Opera", "opera", "[\\/ ]([\\d\\w\\.\\-]+)"), new UserAgentBrowser("Konqueror", "konqueror", "[\\/ ]([\\d\\w\\.\\-]+)"), new UserAgentBrowser("PS3", "playstation 3", "([\\d\\w\\.\\-]+)\\)\\s*$"), new UserAgentBrowser("PSP", "playstation portable", "([\\d\\w\\.\\-]+)\\)?\\s*$"), new UserAgentBrowser("Lotus", "lotus.notes", "Lotus-Notes\\/([\\w.]+)"), new UserAgentBrowser("Thunderbird", "thunderbird", "[\\/ ]([\\d\\w\\.\\-]+)"), new UserAgentBrowser("Netscape", "netscape", "[\\/ ]([\\d\\w\\.\\-]+)"), new UserAgentBrowser("Seamonkey", "seamonkey", "[\\/ ]([\\d\\w\\.\\-]+)"), new UserAgentBrowser("Outlook", "microsoft.outlook", "[\\/ ]([\\d\\w\\.\\-]+)"), new UserAgentBrowser("Evolution", "evolution", "[\\/ ]([\\d\\w\\.\\-]+)"), new UserAgentBrowser("MSIE", "msie", "msie ([\\d\\w\\.\\-]+)"), new UserAgentBrowser("MSIE11", "rv:11", "rv:([\\d\\w\\.\\-]+)"), new UserAgentBrowser("Gabble", "Gabble", "Gabble\\/([\\d\\w\\.\\-]+)"), new UserAgentBrowser("Yammer Desktop", "AdobeAir", "([\\d\\w\\.\\-]+)\\/Yammer"), new UserAgentBrowser("Yammer Mobile", "Yammer[\\s]+([\\d\\w\\.\\-]+)", "Yammer[\\s]+([\\d\\w\\.\\-]+)"), new UserAgentBrowser("Apache HTTP Client", "Apache\\\\-HttpClient", "Apache\\-HttpClient\\/([\\d\\w\\.\\-]+)"), new UserAgentBrowser("BlackBerry", "BlackBerry", "BlackBerry[\\d]+\\/([\\d\\w\\.\\-]+)"), new UserAgentBrowser("iPhone", "iPhone", "Mobile\\/([\\d\\w\\.\\-]+)"), new UserAgentBrowser("Html5Plus", "Html5Plus", "Html5Plus\\/([\\d\\w\\.\\-]+)"), new UserAgentBrowser("uni-app", "uni-app", "uni-app"));
    private Pattern versionPattern;

    public UserAgentBrowser(String name, String regex, String versionRegex) {
        super(name, regex);
        if (Other_Version.equals(versionRegex)) {
            versionRegex = name + versionRegex;
        }
        if (null != versionRegex) {
            this.versionPattern = Pattern.compile(versionRegex, 2);
        }
    }

    public String getVersion(String userAgentString) {
        return this.getGroup1(this.versionPattern, userAgentString);
    }

    private String getGroup1(Pattern pattern, String content) {
        return this.get(pattern, content, 1);
    }

    private String get(Pattern pattern, String content, int groupIndex) {
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(groupIndex);
        }
        return null;
    }

    public boolean isMobile() {
        return "PSP".equals(this.getName());
    }
}

