/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.annotation.processor;

import androidx.annotation.Keep;
import com.google.auto.service.AutoService;
import com.mapbox.annotation.module.MapboxModule;
import com.mapbox.annotation.module.MapboxModuleType;
import com.mapbox.annotation.processor.Module;
import com.mapbox.annotation.processor.UtilsKt;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.jvm.JvmAnnotations;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SupportedOptions(value={"kapt.kotlin.generated"})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010\f2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/mapbox/annotation/processor/ModuleProviderGenerator;", "Ljavax/annotation/processing/AbstractProcessor;", "()V", "generateModuleConfiguration", "", "module", "Lcom/mapbox/annotation/processor/Module;", "getModules", "", "roundEnvironment", "Ljavax/annotation/processing/RoundEnvironment;", "getSupportedAnnotationTypes", "", "", "getSupportedSourceVersion", "Ljavax/lang/model/SourceVersion;", "process", "", "set", "Ljavax/lang/model/element/TypeElement;", "Companion", "annotations-processor"})
@AutoService(value={Processor.class})
public final class ModuleProviderGenerator
extends AbstractProcessor {
    @NotNull
    public static final String KAPT_KOTLIN_GENERATED_OPTION_NAME = "kapt.kotlin.generated";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion sourceVersion = SourceVersion.latest();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sourceVersion), (String)"SourceVersion.latest()");
        return sourceVersion;
    }

    @Override
    @NotNull
    public Set<String> getSupportedAnnotationTypes() {
        Object[] objectArray = new String[1];
        String string = MapboxModule.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MapboxModule::class.java.name");
        objectArray[0] = string;
        return SetsKt.mutableSetOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean process(@Nullable Set<? extends TypeElement> set, @Nullable RoundEnvironment roundEnvironment) {
        void $this$groupByTo$iv$iv;
        List<Module> modules = this.getModules(roundEnvironment);
        Iterable $this$groupBy$iv = modules;
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Module it = (Module)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = destination$iv$iv.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List groupedModules = (List)element$iv;
            boolean bl = false;
            if (groupedModules.size() <= 1) continue;
            ProcessingEnvironment processingEnvironment = this.processingEnv;
            Intrinsics.checkNotNullExpressionValue((Object)processingEnvironment, (String)"processingEnv");
            Messager messager = processingEnvironment.getMessager();
            Intrinsics.checkNotNullExpressionValue((Object)messager, (String)"processingEnv.messager");
            UtilsKt.errorMessage(messager, (Function0<String>)((Function0)new Function0<String>(groupedModules){
                final /* synthetic */ List $groupedModules;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final String invoke() {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = this.$groupedModules;
                    StringBuilder stringBuilder = new StringBuilder().append("\n            Duplicate module declaration for ").append(((Module)this.$groupedModules.get(0)).getName()).append("\n            in\n            ");
                    boolean $i$f$map = false;
                    void var3_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Module module = (Module)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        String string = it.getImplPackage() + '.' + it.getImplClassName();
                        collection.add(string);
                    }
                    collection = (List)destination$iv$iv;
                    return StringsKt.trimIndent((String)stringBuilder.append(collection).append(".\n          ").toString());
                }
                {
                    this.$groupedModules = list;
                    super(0);
                }
            }));
        }
        $this$forEach$iv = modules;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Module it = (Module)element$iv;
            boolean bl = false;
            this.generateModuleConfiguration(it);
        }
        return true;
    }

    private final List<Module> getModules(RoundEnvironment roundEnvironment) {
        boolean bl = false;
        List modules = new ArrayList();
        Object object = roundEnvironment;
        if (object != null && (object = object.getElementsAnnotatedWith(MapboxModule.class)) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Element element = (Element)element$iv;
                boolean bl2 = false;
                if (!(element instanceof TypeElement)) continue;
                ProcessingEnvironment processingEnvironment = this.processingEnv;
                Intrinsics.checkNotNullExpressionValue((Object)processingEnvironment, (String)"processingEnv");
                String implPackage = processingEnvironment.getElementUtils().getPackageOf(element).toString();
                String implClassName = ((TypeElement)element).getSimpleName().toString();
                MapboxModule annotation = element.getAnnotation(MapboxModule.class);
                boolean enableConfiguration = annotation.enableConfiguration();
                MapboxModuleType type = annotation.type();
                modules.add(new Module(enableConfiguration, type.name(), type.getSimplifiedName(), type.getInterfacePackage(), type.getInterfaceClassName(), implPackage, implClassName));
            }
        }
        return CollectionsKt.toList((Iterable)modules);
    }

    private final void generateModuleConfiguration(Module module) {
        block2: {
            ProcessingEnvironment processingEnvironment = this.processingEnv;
            Intrinsics.checkNotNullExpressionValue((Object)processingEnvironment, (String)"processingEnv");
            Messager messager = processingEnvironment.getMessager();
            Intrinsics.checkNotNullExpressionValue((Object)messager, (String)"processingEnv.messager");
            UtilsKt.noteMessage(messager, (Function0<String>)((Function0)new Function0<String>(module){
                final /* synthetic */ Module $module;

                @NotNull
                public final String invoke() {
                    return "Generating module configuration class for " + this.$module.getImplPackage() + '.' + this.$module.getImplClassName();
                }
                {
                    this.$module = module;
                    super(0);
                }
            }));
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Mapbox_%sModuleConfiguration";
            Object object = new Object[]{module.getSimplifiedName()};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            FileSpec.Builder fileBuilder = FileSpec.Companion.builder("com.mapbox.module", string2);
            string = StringCompanionObject.INSTANCE;
            object = "Mapbox_%sModuleConfiguration";
            Object object2 = new Object[]{module.getSimplifiedName()};
            boolean bl2 = false;
            String string3 = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            TypeSpec.Builder typeBuilder = TypeSpec.Companion.objectBuilder(string3).addKdoc("Configuration provider for " + module.getSimplifiedName() + " module.", new Object[0]).addAnnotation(Reflection.getOrCreateKotlinClass(Keep.class)).addProperty(JvmAnnotations.jvmStatic((PropertySpec.Builder)PropertySpec.Companion.builder("enableConfiguration", Reflection.getOrCreateKotlinClass(Boolean.TYPE), new KModifier[0]).initializer(String.valueOf(module.getEnableConfiguration()), new Object[0])).build());
            if (module.getEnableConfiguration()) {
                TypeSpec.Builder builder = TypeSpec.Companion.interfaceBuilder("ModuleProvider");
                object = StringCompanionObject.INSTANCE;
                object2 = "create%s";
                Object[] objectArray = new Object[]{module.getSimplifiedName()};
                boolean bl3 = false;
                String string4 = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                TypeSpec providerInterface = builder.addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder(string4).addModifiers(new KModifier[]{KModifier.ABSTRACT}), (TypeName)((TypeName)ClassName.Companion.bestGuess(module.getInterfacePackage() + '.' + module.getInterfaceClassName())), null, (int)2, null).build()).build();
                typeBuilder.addProperty(JvmAnnotations.jvmStatic((PropertySpec.Builder)PropertySpec.Builder.mutable$default((PropertySpec.Builder)PropertySpec.Companion.builder("moduleProvider", TypeName.copy$default((TypeName)((TypeName)ClassName.Companion.bestGuess("ModuleProvider")), (boolean)true, null, (int)2, null), new KModifier[0]).addKdoc("Set this dependency provider before initializing any components of the modularized library.\n\nWhen you're not using the library anymore, you should pass `null` to clean up the provider reference and prevent memory leaks.", new Object[0]), (boolean)false, (int)1, null).initializer("null", new Object[0])).build()).addType(providerInterface);
            } else {
                typeBuilder.addProperty(JvmAnnotations.jvmStatic((PropertySpec.Builder)PropertySpec.Companion.builder("implClass", (TypeName)ParameterizedTypeName.Companion.get(ClassName.Companion.bestGuess("java.lang.Class"), new TypeName[]{(TypeName)ClassName.Companion.bestGuess(module.getImplPackage() + '.' + module.getImplClassName())}), new KModifier[0]).initializer(module.getImplClassName() + "::class.java", new Object[0])).build());
            }
            fileBuilder.addType(typeBuilder.build());
            FileSpec file = fileBuilder.build();
            ProcessingEnvironment processingEnvironment2 = this.processingEnv;
            Intrinsics.checkNotNullExpressionValue((Object)processingEnvironment2, (String)"processingEnv");
            String string5 = processingEnvironment2.getOptions().get(KAPT_KOTLIN_GENERATED_OPTION_NAME);
            if (string5 == null) break block2;
            object = string5;
            boolean bl4 = false;
            boolean bl5 = false;
            Object it = object;
            boolean bl6 = false;
            Path path = Paths.get((String)it, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(it)");
            file.writeTo(path);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/mapbox/annotation/processor/ModuleProviderGenerator$Companion;", "", "()V", "KAPT_KOTLIN_GENERATED_OPTION_NAME", "", "annotations-processor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

