/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal.eval;

import com.microsoft.java.debug.core.IBreakpoint;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.plugin.internal.JdtUtils;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.eval.ICompiledExpression;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.eval.ast.engine.ASTEvaluationEngine;
import org.eclipse.jdt.internal.launching.JavaSourceLookupDirector;

public class JdtEvaluationProvider
implements IEvaluationProvider {
    private static final Logger logger = Logger.getLogger("java-debug");
    private IJavaProject project;
    private ILaunch launch;
    private JDIDebugTarget debugTarget;
    private Map<ThreadReference, JDIThread> threadMap = new HashMap<ThreadReference, JDIThread>();
    private HashMap<String, Object> options = new HashMap();
    private IDebugAdapterContext context;
    private List<IJavaProject> projectCandidates;
    private Set<String> visitedClassNames = new HashSet<String>();

    public void initialize(IDebugAdapterContext context, Map<String, Object> props) {
        if (props == null) {
            throw new IllegalArgumentException("argument is null");
        }
        this.options.putAll(props);
        this.context = context;
    }

    public CompletableFuture<Value> evaluateForBreakpoint(IBreakpoint breakpoint, ThreadReference thread, Map<IBreakpoint, Object> breakpointExpressionMap) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("breakpoint is null.");
        }
        if (StringUtils.isBlank((CharSequence)breakpoint.getCondition())) {
            throw new IllegalArgumentException("breakpoint is not a conditional breakpoint.");
        }
        CompletableFuture<Value> completableFuture = new CompletableFuture<Value>();
        try {
            this.ensureDebugTarget(thread.virtualMachine(), thread, 0);
            JDIThread jdiThread = this.getMockJDIThread(thread);
            JDIStackFrame stackframe = (JDIStackFrame)jdiThread.getTopStackFrame();
            ASTEvaluationEngine engine = new ASTEvaluationEngine(this.project, (IJavaDebugTarget)this.debugTarget);
            ICompiledExpression ie = (ICompiledExpression)breakpointExpressionMap.computeIfAbsent(breakpoint, bp -> engine.getCompiledExpression(bp.getCondition(), (IJavaStackFrame)stackframe));
            this.internalEvaluate(engine, ie, (IJavaStackFrame)stackframe, completableFuture);
            return completableFuture;
        }
        catch (Exception ex) {
            completableFuture.completeExceptionally(ex);
            return completableFuture;
        }
    }

    public CompletableFuture<Value> evaluate(String expression, ThreadReference thread, int depth) {
        CompletableFuture<Value> completableFuture = new CompletableFuture<Value>();
        try {
            this.ensureDebugTarget(thread.virtualMachine(), thread, depth);
            JDIThread jdiThread = this.getMockJDIThread(thread);
            JDIStackFrame stackframe = this.createStackFrame(jdiThread, depth);
            if (stackframe == null) {
                logger.severe("Cannot evaluate because the stackframe is not available.");
                throw new IllegalStateException("Cannot evaluate because the stackframe is not available.");
            }
            ASTEvaluationEngine engine = new ASTEvaluationEngine(this.project, (IJavaDebugTarget)this.debugTarget);
            ICompiledExpression ie = engine.getCompiledExpression(expression, (IJavaStackFrame)stackframe);
            this.internalEvaluate(engine, ie, (IJavaStackFrame)stackframe, completableFuture);
            return completableFuture;
        }
        catch (Exception ex) {
            completableFuture.completeExceptionally(ex);
            return completableFuture;
        }
    }

    private void initializeProjectCandidates(String mainclass) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        List projects = Arrays.stream(root.getProjects()).map(JdtUtils::getJavaProject).filter(p -> {
            try {
                return p != null && p.hasBuildState();
            }
            catch (Exception exception) {
                return false;
            }
        }).collect(Collectors.toList());
        if (projects.size() > 1 && StringUtils.isNotBlank((CharSequence)mainclass)) {
            projects = Arrays.stream(root.getProjects()).map(JdtUtils::getJavaProject).filter(p -> {
                try {
                    return p.findType(mainclass) != null;
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }).collect(Collectors.toList());
            this.visitedClassNames.add(mainclass);
        }
        if (projects.size() == 1) {
            this.project = (IJavaProject)projects.get(0);
        }
        this.projectCandidates = projects;
    }

    private void findJavaProjectByStackFrame(ThreadReference thread, int depth) {
        if (this.projectCandidates == null) {
            this.initializeProjectCandidates((String)this.options.get("mainClass"));
            if (this.project != null) {
                return;
            }
        }
        if (this.projectCandidates.size() == 0) {
            logger.severe("No project is available for evaluation.");
            throw new IllegalStateException("No project is available for evaluation.");
        }
        try {
            StackFrame sf = thread.frame(depth);
            String typeName = sf.location().method().declaringType().name();
            List<IJavaProject> validProjects = this.visitedClassNames.contains(typeName) ? this.projectCandidates : this.projectCandidates.stream().filter(p -> {
                try {
                    return !this.visitedClassNames.contains(typeName) && p.findType(typeName) != null;
                }
                catch (Exception exception) {
                    return false;
                }
            }).collect(Collectors.toList());
            this.visitedClassNames.add(typeName);
            if (validProjects.size() != 1) {
                if (validProjects.size() == 0) {
                    logger.severe("No project is available for evaluation.");
                    throw new IllegalStateException("No project is available for evaluation, .");
                }
                this.projectCandidates = validProjects;
                logger.severe("Multiple projects are valid for evaluation.");
                throw new IllegalStateException("Multiple projects are found, please specify projectName in launch.json.");
            }
            this.project = validProjects.get(0);
        }
        catch (Exception exception) {}
        logger.severe("Cannot evaluate when the project is not specified.");
        throw new IllegalStateException("Please specify projectName in launch.json.");
    }

    private JDIStackFrame createStackFrame(JDIThread thread, int depth) {
        try {
            IStackFrame[] jdiStackFrames = thread.getStackFrames();
            return jdiStackFrames.length > depth ? (JDIStackFrame)jdiStackFrames[depth] : null;
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JDIThread getMockJDIThread(final ThreadReference thread) {
        Map<ThreadReference, JDIThread> map = this.threadMap;
        synchronized (map) {
            return this.threadMap.computeIfAbsent(thread, threadKey -> new JDIThread(this.debugTarget, thread){

                protected synchronized void invokeComplete(int restoreTimeout) {
                    super.invokeComplete(restoreTimeout);
                    JdtEvaluationProvider.this.context.getStackFrameManager().reloadStackFrames(thread);
                }
            });
        }
    }

    private void internalEvaluate(ASTEvaluationEngine engine, ICompiledExpression compiledExpression, IJavaStackFrame stackframe, CompletableFuture<Value> completableFuture) {
        try {
            engine.evaluateExpression(compiledExpression, stackframe, evaluateResult -> {
                if (evaluateResult == null || evaluateResult.hasErrors()) {
                    Object ex = evaluateResult.getException() != null ? evaluateResult.getException() : new RuntimeException(StringUtils.join((Object[])evaluateResult.getErrorMessages()));
                    completableFuture.completeExceptionally((Throwable)ex);
                    return;
                }
                try {
                    Value value = (Value)FieldUtils.readField((Object)evaluateResult.getValue(), (String)"fValue", (boolean)true);
                    completableFuture.complete(value);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    completableFuture.completeExceptionally(ex);
                }
            }, 0, false);
        }
        catch (Exception ex) {
            completableFuture.completeExceptionally(ex);
        }
    }

    public boolean isInEvaluation(ThreadReference thread) {
        return this.debugTarget != null && this.getMockJDIThread(thread).isPerformingEvaluation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearState(ThreadReference thread) {
        if (this.debugTarget != null) {
            Map<ThreadReference, JDIThread> map = this.threadMap;
            synchronized (map) {
                JDIThread jdiThread = this.threadMap.get(thread);
                if (jdiThread != null) {
                    try {
                        jdiThread.terminateEvaluation();
                    }
                    catch (DebugException e) {
                        logger.warning(String.format("Error stopping evalutoin on thread %d: %s", thread.uniqueID(), e.toString()));
                    }
                    this.threadMap.remove(thread);
                }
            }
        }
    }

    private void ensureDebugTarget(VirtualMachine vm, ThreadReference thread, int depth) {
        if (this.debugTarget == null) {
            if (this.project == null) {
                String projectName = (String)this.options.get("projectName");
                if (StringUtils.isBlank((CharSequence)projectName)) {
                    this.findJavaProjectByStackFrame(thread, depth);
                } else {
                    IJavaProject javaProject = JdtUtils.getJavaProject(projectName);
                    if (javaProject == null) {
                        throw new IllegalStateException(String.format("Project %s cannot be found.", projectName));
                    }
                    this.project = javaProject;
                }
            }
            if (this.launch == null) {
                this.launch = JdtEvaluationProvider.createILaunchMock(this.project);
            }
            this.debugTarget = new JDIDebugTarget(this.launch, vm, "", false, false, null, false){

                protected synchronized void initialize() {
                }
            };
        }
    }

    private static ILaunch createILaunchMock(final IJavaProject project) {
        return new ILaunch(){
            private AbstractSourceLookupDirector locator;

            public boolean canTerminate() {
                return false;
            }

            public boolean isTerminated() {
                return false;
            }

            public void terminate() throws DebugException {
            }

            public <T> T getAdapter(Class<T> arg0) {
                return null;
            }

            public void addDebugTarget(IDebugTarget arg0) {
            }

            public void addProcess(IProcess arg0) {
            }

            public String getAttribute(String arg0) {
                return null;
            }

            public Object[] getChildren() {
                return null;
            }

            public IDebugTarget getDebugTarget() {
                return null;
            }

            public IDebugTarget[] getDebugTargets() {
                return null;
            }

            public ILaunchConfiguration getLaunchConfiguration() {
                return null;
            }

            public String getLaunchMode() {
                return null;
            }

            public IProcess[] getProcesses() {
                return null;
            }

            public ISourceLocator getSourceLocator() {
                if (this.locator != null) {
                    return this.locator;
                }
                this.locator = new JavaSourceLookupDirector();
                try {
                    this.locator.setSourceContainers(new ProjectSourceContainer(project.getProject(), true).getSourceContainers());
                }
                catch (CoreException e) {
                    logger.severe(String.format("Cannot initialize JavaSourceLookupDirector: %s", e.toString()));
                }
                this.locator.initializeParticipants();
                return this.locator;
            }

            public boolean hasChildren() {
                return false;
            }

            public void removeDebugTarget(IDebugTarget arg0) {
            }

            public void removeProcess(IProcess arg0) {
            }

            public void setAttribute(String arg0, String arg1) {
            }

            public void setSourceLocator(ISourceLocator arg0) {
            }
        };
    }
}

