/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.core.DebugUtility;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.VirtualMachineManagerImpl;
import org.eclipse.jdi.internal.connect.ConnectorImpl;
import org.eclipse.jdi.internal.connect.SocketLaunchingConnectorImpl;
import org.eclipse.jdi.internal.connect.SocketListeningConnectorImpl;

public class AdvancedLaunchingConnector
extends SocketLaunchingConnectorImpl
implements LaunchingConnector {
    private static final int ACCEPT_TIMEOUT = 10000;

    public AdvancedLaunchingConnector(VirtualMachineManagerImpl virtualMachineManager) {
        super(virtualMachineManager);
    }

    @Override
    public Map<String, Connector.Argument> defaultArguments() {
        Map defaultArgs = super.defaultArguments();
        AdvancedStringArgumentImpl cwdArg = new AdvancedStringArgumentImpl("cwd", "Current working directory", "cwd", false);
        cwdArg.setValue(null);
        defaultArgs.put("cwd", cwdArg);
        AdvancedStringArgumentImpl envArg = new AdvancedStringArgumentImpl("env", "Environment variables", "env", false);
        envArg.setValue(null);
        defaultArgs.put("env", envArg);
        return defaultArgs;
    }

    @Override
    public String name() {
        return "com.microsoft.java.debug.AdvancedLaunchingConnector";
    }

    @Override
    public VirtualMachine launch(Map<String, ? extends Connector.Argument> connectionArgs) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        VirtualMachineImpl vm;
        String cwd = connectionArgs.get("cwd").value();
        File workingDir = null;
        if (cwd != null && Files.isDirectory(Paths.get(cwd, new String[0]), new LinkOption[0])) {
            workingDir = new File(cwd);
        }
        String[] envVars = null;
        try {
            envVars = DebugUtility.decodeArrayArgument((String)connectionArgs.get("env").value());
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        SocketListeningConnectorImpl listenConnector = new SocketListeningConnectorImpl(this.virtualMachineManager());
        Map args = listenConnector.defaultArguments();
        ((Connector.IntegerArgument)args.get("timeout")).setValue(10000);
        String address = listenConnector.startListening(args);
        String[] cmds = AdvancedLaunchingConnector.constructLaunchCommand(connectionArgs, address);
        Process process = Runtime.getRuntime().exec(cmds, envVars, workingDir);
        try {
            vm = (VirtualMachineImpl)listenConnector.accept(args);
        }
        catch (IllegalConnectorArgumentsException | IOException exception) {
            process.destroy();
            throw new VMStartException(String.format("VM did not connect within given time: %d ms", 10000), process);
        }
        vm.setLaunchedProcess(process);
        return vm;
    }

    private static String[] constructLaunchCommand(Map<String, ? extends Connector.Argument> launchingOptions, String address) {
        String javaHome = launchingOptions.get("home").value();
        String javaExec = launchingOptions.get("vmexec").value();
        String slash = System.getProperty("file.separator");
        boolean suspend = Boolean.valueOf(launchingOptions.get("suspend").value());
        String javaOptions = launchingOptions.get("options").value();
        String main = launchingOptions.get("main").value();
        StringBuilder execString = new StringBuilder();
        execString.append("\"" + javaHome + slash + "bin" + slash + javaExec + "\"");
        execString.append(" -Xdebug -Xnoagent -Djava.compiler=NONE");
        execString.append(" -Xrunjdwp:transport=dt_socket,address=" + address + ",server=n,suspend=" + (suspend ? "y" : "n"));
        if (javaOptions != null) {
            execString.append(" " + javaOptions);
        }
        execString.append(" " + main);
        return DebugUtility.parseArguments((String)execString.toString()).toArray(new String[0]);
    }

    class AdvancedStringArgumentImpl
    extends ConnectorImpl.StringArgumentImpl
    implements Connector.StringArgument {
        private static final long serialVersionUID = 1L;

        protected AdvancedStringArgumentImpl(String name, String description, String label, boolean mustSpecify) {
            super((ConnectorImpl)AdvancedLaunchingConnector.this, name, description, label, mustSpecify);
        }
    }
}

