/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.StackFrameUtility;
import com.microsoft.java.debug.core.adapter.HotCodeReplaceEvent;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IHotCodeReplaceProvider;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.plugin.internal.JdtUtils;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.StepRequest;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.ISourceAttribute;
import org.eclipse.jdt.internal.core.util.Util;

public class JavaHotCodeReplaceProvider
implements IHotCodeReplaceProvider,
IResourceChangeListener {
    private static final Logger logger = Logger.getLogger("java-debug");
    private static final String CLASS_FILE_EXTENSION = "class";
    private IDebugSession currentDebugSession;
    private IDebugAdapterContext context;
    private Map<ThreadReference, List<StackFrame>> threadFrameMap = new HashMap<ThreadReference, List<StackFrame>>();
    private List<Consumer<List<String>>> consumers = new ArrayList<Consumer<List<String>>>();
    private PublishSubject<HotCodeReplaceEvent> eventSubject = PublishSubject.create();
    private List<IResource> deltaResources = new ArrayList<IResource>();
    private List<String> deltaClassNames = new ArrayList<String>();
    private ChangedClassFilesVisitor classFilesVisitor = new ChangedClassFilesVisitor();

    public void initialize(IDebugAdapterContext context, Map<String, Object> options) {
        if (DebugSettings.getCurrent().hotCodeReplace != DebugSettings.HotCodeReplace.NEVER) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 16);
        }
        this.context = context;
        this.currentDebugSession = context.getDebugSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        ChangedClassFilesVisitor visitor;
        if (event.getType() == 16 && (visitor = this.getChangedClassFiles(event)) != null) {
            List<IResource> resources = visitor.getChangedClassFiles();
            List<String> classNames = visitor.getQualifiedNamesList();
            JavaHotCodeReplaceProvider javaHotCodeReplaceProvider = this;
            synchronized (javaHotCodeReplaceProvider) {
                this.deltaResources.addAll(resources);
                this.deltaClassNames.addAll(classNames);
            }
            this.publishEvent(HotCodeReplaceEvent.EventType.BUILD_COMPLETE, "Build completed.");
        }
    }

    public void onClassRedefined(Consumer<List<String>> consumer) {
        this.consumers.add(consumer);
    }

    public CompletableFuture<List<String>> redefineClasses() {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<String> classNames = new ArrayList<String>();
            JavaHotCodeReplaceProvider javaHotCodeReplaceProvider = this;
            synchronized (javaHotCodeReplaceProvider) {
                classNames.addAll(this.deltaClassNames);
                this.doHotCodeReplace(this.deltaResources, this.deltaClassNames);
                this.deltaResources.clear();
                this.deltaClassNames.clear();
            }
            return classNames;
        });
    }

    public Observable<HotCodeReplaceEvent> getEventHub() {
        return this.eventSubject;
    }

    private void publishEvent(HotCodeReplaceEvent.EventType type, String message) {
        this.eventSubject.onNext((Object)new HotCodeReplaceEvent(type, message));
    }

    private void publishEvent(HotCodeReplaceEvent.EventType type, String message, Object data) {
        this.eventSubject.onNext((Object)new HotCodeReplaceEvent(type, message, data));
    }

    private void doHotCodeReplace(List<IResource> resourcesToReplace, List<String> qualifiedNamesToReplace) {
        block16: {
            if (this.context == null || this.currentDebugSession == null) {
                return;
            }
            if (resourcesToReplace == null || qualifiedNamesToReplace == null || qualifiedNamesToReplace.isEmpty() || resourcesToReplace.isEmpty()) {
                return;
            }
            this.filterNotLoadedTypes(resourcesToReplace, qualifiedNamesToReplace);
            if (qualifiedNamesToReplace.isEmpty()) {
                return;
            }
            if (!this.currentDebugSession.getVM().canRedefineClasses()) {
                return;
            }
            this.publishEvent(HotCodeReplaceEvent.EventType.STARTING, "Start hot code replacement procedure...");
            try {
                try {
                    ArrayList<ThreadReference> poppedThreads = new ArrayList<ThreadReference>();
                    boolean framesPopped = false;
                    if (this.currentDebugSession.getVM().canPopFrames()) {
                        try {
                            this.attemptPopFrames(resourcesToReplace, qualifiedNamesToReplace, poppedThreads);
                            framesPopped = true;
                        }
                        catch (DebugException e) {
                            logger.log(Level.WARNING, "Failed to pop frames " + e.getMessage(), e);
                        }
                    }
                    this.redefineTypesJDK(resourcesToReplace, qualifiedNamesToReplace);
                    for (Consumer<List<String>> consumer : this.consumers) {
                        consumer.accept(qualifiedNamesToReplace);
                    }
                    if (this.containsObsoleteMethods()) {
                        this.publishEvent(HotCodeReplaceEvent.EventType.ERROR, "JVM contains obsolete methods");
                    }
                    if (this.currentDebugSession.getVM().canPopFrames() && framesPopped) {
                        this.attemptStepIn(poppedThreads);
                    } else {
                        this.attemptDropToFrame(resourcesToReplace, qualifiedNamesToReplace);
                    }
                }
                catch (DebugException e) {
                    logger.log(Level.SEVERE, "Failed to complete hot code replace: " + e.getMessage(), e);
                    this.publishEvent(HotCodeReplaceEvent.EventType.END, "Completed hot code replace", qualifiedNamesToReplace);
                    break block16;
                }
            }
            catch (Throwable throwable) {
                this.publishEvent(HotCodeReplaceEvent.EventType.END, "Completed hot code replace", qualifiedNamesToReplace);
                throw throwable;
            }
            this.publishEvent(HotCodeReplaceEvent.EventType.END, "Completed hot code replace", qualifiedNamesToReplace);
        }
        this.threadFrameMap.clear();
    }

    private void filterNotLoadedTypes(List<IResource> resources, List<String> qualifiedNames) {
        int i = 0;
        int numElements = qualifiedNames.size();
        while (i < numElements) {
            String name = qualifiedNames.get(i);
            List<ReferenceType> list = this.getJdiClassesByName(name);
            if (list.isEmpty()) {
                qualifiedNames.remove(i);
                resources.remove(i);
                --i;
                --numElements;
            }
            ++i;
        }
    }

    private List<ReferenceType> getJdiClassesByName(String className) {
        try {
            VirtualMachine vm = this.currentDebugSession.getVM();
            if (vm != null) {
                return vm.classesByName(className);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {}
        return Collections.emptyList();
    }

    private void attemptPopFrames(List<IResource> resources, List<String> replacedClassNames, List<ThreadReference> poppedThreads) throws DebugException {
        List<StackFrame> popFrames = this.getAffectedFrames(this.currentDebugSession.getAllThreads(), replacedClassNames);
        for (StackFrame popFrame : popFrames) {
            try {
                this.popStackFrame(popFrame);
                poppedThreads.add(popFrame.thread());
            }
            catch (DebugException debugException) {
                poppedThreads.remove(popFrame.thread());
            }
        }
    }

    private void attemptStepIn(List<ThreadReference> threads) {
        for (ThreadReference thread : threads) {
            this.stepIntoThread(thread);
        }
    }

    private void attemptDropToFrame(List<IResource> resources, List<String> replacedClassNames) throws DebugException {
        List<StackFrame> dropFrames = this.getAffectedFrames(this.currentDebugSession.getAllThreads(), replacedClassNames);
        for (StackFrame dropFrame : dropFrames) {
            this.dropToStackFrame(dropFrame);
        }
    }

    private List<StackFrame> getAffectedFrames(List<ThreadReference> threads, List<String> replacedClassNames) throws DebugException {
        ArrayList<StackFrame> popFrames = new ArrayList<StackFrame>();
        for (ThreadReference thread : threads) {
            StackFrame affectedFrame;
            if (!thread.isSuspended() || (affectedFrame = this.getAffectedFrame(thread, replacedClassNames)) == null || !this.supportsDropToFrame(thread, affectedFrame)) continue;
            popFrames.add(affectedFrame);
        }
        return popFrames;
    }

    private StackFrame getAffectedFrame(ThreadReference thread, List<String> replacedClassNames) throws DebugException {
        List<StackFrame> frames = this.getStackFrames(thread, false);
        StackFrame affectedFrame = null;
        int i = 0;
        block0: while (i < frames.size()) {
            StackFrame frame = frames.get(i);
            if (this.containsChangedType(frame, replacedClassNames)) {
                if (this.supportsDropToFrame(thread, frame)) {
                    affectedFrame = frame;
                    break;
                }
                int j = i;
                while (j > 0) {
                    if (!this.supportsDropToFrame(thread, frame = frames.get(--j))) continue;
                    affectedFrame = frame;
                    break block0;
                }
                break;
            }
            ++i;
        }
        return affectedFrame;
    }

    private boolean containsChangedType(StackFrame frame, List<String> replacedClassNames) throws DebugException {
        String declaringTypeName = JdtUtils.getDeclaringTypeName(frame);
        if (replacedClassNames.contains(declaringTypeName)) {
            return true;
        }
        for (String className : replacedClassNames) {
            int index = className.indexOf(36);
            if (index <= -1 || !declaringTypeName.equals(className.substring(0, index))) continue;
            return true;
        }
        return false;
    }

    private boolean supportsDropToFrame(ThreadReference thread, StackFrame frame) {
        List<StackFrame> frames = this.getStackFrames(thread, false);
        int i = 0;
        while (i < frames.size()) {
            if (StackFrameUtility.isNative((StackFrame)frames.get(i))) {
                return false;
            }
            if (frames.get(i) == frame) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void popStackFrame(StackFrame frame) throws DebugException {
        if (frame != null) {
            ThreadReference thread = frame.thread();
            List<StackFrame> frames = this.getStackFrames(thread, false);
            int desiredSize = frames.indexOf(frame);
            while (desiredSize >= 0) {
                StackFrameUtility.pop((StackFrame)frames.get(0));
                frames = this.getStackFrames(thread, true);
                --desiredSize;
            }
        }
    }

    protected void dropToStackFrame(StackFrame frame) throws DebugException {
        this.popStackFrame(frame);
        this.stepIntoThread(frame.thread());
    }

    private void redefineTypesJDK(List<IResource> resources, List<String> qualifiedNames) throws DebugException {
        Map<ReferenceType, byte[]> typesToBytes = this.getTypesToBytes(resources, qualifiedNames);
        try {
            this.currentDebugSession.getVM().redefineClasses(typesToBytes);
        }
        catch (ClassCircularityError | ClassFormatError | NoClassDefFoundError | UnsupportedOperationException | VerifyError e) {
            this.publishEvent(HotCodeReplaceEvent.EventType.ERROR, e.getMessage());
            throw new DebugException("Failed to redefine classes: " + e.getMessage());
        }
    }

    private void stepIntoThread(ThreadReference thread) {
        StepRequest request = DebugUtility.createStepIntoRequest((ThreadReference)thread, (String[])this.context.getStepFilters().classNameFilters);
        this.currentDebugSession.getEventHub().stepEvents().filter(debugEvent -> request.equals(debugEvent.event.request())).take(1L).subscribe(debugEvent -> {
            debugEvent.shouldResume = false;
            this.context.getProtocolServer().sendEvent((Events.DebugEvent)new Events.StoppedEvent("step", thread.uniqueID()));
            this.context.getProtocolServer().sendEvent((Events.DebugEvent)new Events.ContinuedEvent(thread.uniqueID()));
        });
        request.enable();
        thread.resume();
    }

    private Map<ReferenceType, byte[]> getTypesToBytes(List<IResource> resources, List<String> qualifiedNames) {
        HashMap<ReferenceType, byte[]> typesToBytes = new HashMap<ReferenceType, byte[]>(resources.size());
        Iterator<IResource> resourceIter = resources.iterator();
        Iterator<String> nameIter = qualifiedNames.iterator();
        while (resourceIter.hasNext()) {
            IResource resource = resourceIter.next();
            String name = nameIter.next();
            List<ReferenceType> classes = this.getJdiClassesByName(name);
            byte[] bytes = null;
            try {
                bytes = Util.getResourceContentsAsByteArray((IFile)((IFile)resource));
            }
            catch (CoreException coreException) {
                continue;
            }
            for (ReferenceType type : classes) {
                typesToBytes.put(type, bytes);
            }
        }
        return typesToBytes;
    }

    private ChangedClassFilesVisitor getChangedClassFiles(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (event.getType() != 16 || delta == null) {
            return null;
        }
        this.classFilesVisitor.reset();
        try {
            delta.accept((IResourceDeltaVisitor)this.classFilesVisitor);
        }
        catch (CoreException coreException) {
            return null;
        }
        return this.classFilesVisitor;
    }

    public static IJavaElement findElement(String qualifiedTypeName, IJavaProject project) throws CoreException {
        String path = qualifiedTypeName;
        String[] javaLikeExtensions = JavaCore.getJavaLikeExtensions();
        int pos = path.indexOf(36);
        if (pos != -1) {
            path = path.substring(0, pos);
        }
        path = path.replace('.', '/');
        path = String.valueOf(path) + ".";
        String[] stringArray = javaLikeExtensions;
        int n = javaLikeExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            IJavaElement element = project.findElement((IPath)new Path(String.valueOf(path) + ext));
            if (element != null) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private boolean containsObsoleteMethods() throws DebugException {
        List threads = this.currentDebugSession.getAllThreads();
        for (ThreadReference thread : threads) {
            List<StackFrame> frames;
            if (!thread.isSuspended() || (frames = this.getStackFrames(thread, true)) == null || frames.isEmpty()) continue;
            for (StackFrame frame : frames) {
                if (!StackFrameUtility.isObsolete((StackFrame)frame)) continue;
                return true;
            }
        }
        return false;
    }

    private List<StackFrame> getStackFrames(ThreadReference thread, boolean refresh) {
        return this.threadFrameMap.compute(thread, (key, oldValue) -> {
            try {
                return oldValue == null || refresh ? key.frames() : oldValue;
            }
            catch (IncompatibleThreadStateException e) {
                logger.log(Level.SEVERE, "Failed to get stack frames: " + e.getMessage(), e);
                return oldValue;
            }
        });
    }

    class ChangedClassFilesVisitor
    implements IResourceDeltaVisitor {
        private List<IResource> changedFiles = null;
        private List<String> fullyQualifiedNames = null;

        ChangedClassFilesVisitor() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean visit(IResourceDelta delta) {
            if (delta == null) return false;
            if ((delta.getKind() & 4) == 0) {
                return false;
            }
            IResource resource = delta.getResource();
            if (resource == null) return true;
            switch (resource.getType()) {
                case 1: {
                    if ((delta.getFlags() & 0x100) == 0) {
                        return false;
                    }
                    if (!JavaHotCodeReplaceProvider.CLASS_FILE_EXTENSION.equals(resource.getFullPath().getFileExtension())) return false;
                    IPath localLocation = resource.getLocation();
                    if (localLocation == null) return false;
                    String path = localLocation.toOSString();
                    IClassFileReader reader = ToolFactory.createDefaultClassFileReader((String)path, (int)17);
                    if (reader == null) return false;
                    String qualifiedName = new String(reader.getClassName());
                    boolean hasBlockingErrors = false;
                    try {
                        IResource sourceFile;
                        IJavaProject pro = JavaCore.create((IProject)resource.getProject());
                        ISourceAttribute sourceAttribute = reader.getSourceFileAttribute();
                        String sourceName = null;
                        if (sourceAttribute != null) {
                            sourceName = new String(sourceAttribute.getSourceFileName());
                        }
                        if ((sourceFile = this.getSourceFile(pro, qualifiedName, sourceName)) != null) {
                            IMarker[] problemMarkers = null;
                            IMarker[] iMarkerArray = problemMarkers = sourceFile.findMarkers("org.eclipse.jdt.core.problem", true, 2);
                            int n = problemMarkers.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IMarker problemMarker = iMarkerArray[n2];
                                if (problemMarker.getAttribute("severity", -1) == 2) {
                                    return false;
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (CoreException e) {
                        logger.log(Level.SEVERE, "Failed to visit classes: " + e.getMessage(), e);
                    }
                    if (hasBlockingErrors) return false;
                    this.changedFiles.add(resource);
                    this.fullyQualifiedNames.add(qualifiedName.replace('/', '.'));
                    return false;
                }
            }
            return true;
        }

        public void reset() {
            this.changedFiles = new ArrayList<IResource>();
            this.fullyQualifiedNames = new ArrayList<String>();
        }

        public List<IResource> getChangedClassFiles() {
            return this.changedFiles;
        }

        public List<String> getQualifiedNamesList() {
            return this.fullyQualifiedNames;
        }

        private IResource getSourceFile(IJavaProject project, String qualifiedName, String sourceAttribute) {
            String name = null;
            IJavaElement element = null;
            try {
                if (sourceAttribute == null) {
                    element = JavaHotCodeReplaceProvider.findElement(qualifiedName, project);
                } else {
                    int i = qualifiedName.lastIndexOf(47);
                    if (i > 0) {
                        name = qualifiedName.substring(0, i + 1);
                        name = String.valueOf(name) + sourceAttribute;
                    } else {
                        name = sourceAttribute;
                    }
                    element = project.findElement((IPath)new Path(name));
                }
                if (element instanceof ICompilationUnit) {
                    ICompilationUnit cu = (ICompilationUnit)element;
                    return cu.getCorrespondingResource();
                }
            }
            catch (CoreException e) {
                logger.log(Level.INFO, "Failed to get source file with exception" + e.getMessage(), e);
            }
            return null;
        }
    }
}

