/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.helper;

import com.objectsql.annotation.RdConvert;
import com.objectsql.annotation.RdId;
import com.objectsql.exception.ORMException;
import com.objectsql.handler.IColumnConvert;
import com.objectsql.handler.IQueryConvert;
import com.objectsql.handler.IResultSetHandler;
import com.objectsql.helper.SQLHelper;
import com.objectsql.option.OracleOptions;
import com.objectsql.query.QueryUtils;
import com.objectsql.support.ColumnInfo;
import com.objectsql.support.ColumnType;
import com.objectsql.support.Condition;
import com.objectsql.support.DataType;
import com.objectsql.support.DatabaseTypeHolder;
import com.objectsql.support.Expression;
import com.objectsql.support.IDGenerator;
import com.objectsql.support.KV;
import com.objectsql.support.Options;
import com.objectsql.support.Pair;
import com.objectsql.support.SQLPair;
import com.objectsql.utils.ORMUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SQLHelperCreator {
    public static Map<String, IDGenerator> generatorMap = new HashMap<String, IDGenerator>();
    private static Map<Class, IColumnConvert> columnConvertMap = new HashMap<Class, IColumnConvert>();

    public static SQLHelper delete(Object obj) {
        Class<?> clazz = obj.getClass();
        String tableName = ORMUtils.getTableName(clazz);
        StringBuffer sql = new StringBuffer("DELETE FROM ");
        sql.append(tableName);
        Pair primaryKey = null;
        List<ColumnInfo> infoList = ORMUtils.getColumnInfo(clazz);
        ORMUtils.whenEmpty(infoList, "Get columns cache is empty.");
        for (ColumnInfo info : infoList) {
            if (!info.getPrimaryKey().booleanValue()) continue;
            Object fo = null;
            try {
                Field field = info.getField();
                field.setAccessible(true);
                fo = field.get(obj);
                primaryKey = SQLHelperCreator.handleObject(obj, info, fo);
                break;
            }
            catch (Exception e) {
                throw new ORMException("Delete table when get value error, Column[" + info.getColumnName() + "], field[" + info.getName() + "]");
            }
        }
        ArrayList<Pair> parameters = new ArrayList<Pair>();
        if (primaryKey == null || primaryKey.getValue() == null) {
            throw new ORMException("Delete table without primary key, Class[" + clazz.getName() + "], value[" + obj + "]");
        }
        sql.append(" WHERE ");
        sql.append(primaryKey.getColumn() + " = ? ");
        parameters.add(primaryKey);
        SQLHelper helper = new SQLHelper();
        helper.setSql(sql.toString());
        helper.setParameters(parameters);
        helper.setPair(primaryKey);
        return helper;
    }

    public static SQLHelper delete(Class clazz, Object idObject) {
        String tableName = ORMUtils.getTableName(clazz);
        StringBuffer sql = new StringBuffer("DELETE FROM ");
        sql.append(tableName);
        Pair primaryKey = null;
        List<ColumnInfo> infoList = ORMUtils.getColumnInfo(clazz);
        for (ColumnInfo info : infoList) {
            if (!info.getPrimaryKey().booleanValue()) continue;
            primaryKey = SQLHelperCreator.handleObject(null, info, idObject);
            break;
        }
        ArrayList<Pair> parameters = new ArrayList<Pair>();
        if (primaryKey == null || idObject == null) {
            throw new ORMException("Delete table without primary key, Class[" + clazz.getName() + "], value[" + idObject + "]");
        }
        sql.append(" WHERE ");
        sql.append(primaryKey.getColumn() + " = ? ");
        parameters.add(primaryKey);
        SQLHelper helper = new SQLHelper();
        helper.setPair(primaryKey);
        helper.setSql(sql.toString());
        helper.setParameters(parameters);
        return helper;
    }

    public static SQLHelper deleteBy(Class clazz, Options options, Expression[] expressions) {
        String tableName = ORMUtils.getTableName(clazz);
        if (expressions == null || expressions.length == 0) {
            throw new ORMException("Delete table without expresses, Class[" + clazz.getName() + "]");
        }
        StringBuffer sql = new StringBuffer("DELETE FROM " + tableName + " WHERE ");
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        ArrayList<String> terms = new ArrayList<String>();
        boolean hasExpress = false;
        for (Expression expression : expressions) {
            SQLPair pair;
            if (expression == null || (pair = options.parseExpression(clazz, expression)) == null) continue;
            terms.add(pair.getSql());
            pairs.addAll(pair.getPairs());
            hasExpress = true;
        }
        if (!hasExpress) {
            throw new ORMException("Delete table without expresses, Table[" + clazz.getName() + "]");
        }
        sql.append(ORMUtils.join(terms, " AND "));
        SQLHelper helper = new SQLHelper();
        helper.setSql(sql.toString());
        helper.setParameters(pairs);
        return helper;
    }

    public static SQLHelper deleteBy(Class clazz, Options options, Condition condition) {
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        String conditions = null;
        if (condition != null) {
            conditions = options.getConditions((Object)clazz, ORMUtils.newList(condition), pairs);
        }
        String tableName = ORMUtils.getTableName(clazz);
        if (ORMUtils.isEmpty(conditions)) {
            throw new ORMException("Delete table without conditions, Class[" + clazz.getName() + "]");
        }
        StringBuffer sql = new StringBuffer("DELETE FROM " + tableName + " WHERE " + conditions);
        SQLHelper helper = new SQLHelper();
        helper.setSql(sql.toString());
        helper.setParameters(pairs);
        return helper;
    }

    public static SQLHelper updateTerms(Options option, Object obj, Condition condition, boolean updateNull, String[] nullColumns) {
        ArrayList<String> ncs = new ArrayList<String>();
        if (nullColumns != null && nullColumns.length > 0) {
            ncs.addAll(Arrays.asList(nullColumns));
        }
        Class<?> clazz = obj.getClass();
        String tableName = ORMUtils.getTableName(clazz);
        StringBuffer sql = new StringBuffer("UPDATE ");
        sql.append(tableName);
        sql.append(" SET ");
        ArrayList<Pair> parameters = new ArrayList<Pair>();
        ArrayList<String> sets = new ArrayList<String>();
        Pair primaryKey = null;
        List<ColumnInfo> infoList = ORMUtils.getColumnInfo(clazz);
        ORMUtils.whenTrue(infoList == null, "Get columns cache is empty.");
        String databaseType = DatabaseTypeHolder.get();
        SQLHelper helper = new SQLHelper();
        for (ColumnInfo info : infoList) {
            Object fo = ORMUtils.getFieldValue(obj, info);
            if (info.getPrimaryKey().booleanValue()) {
                helper.setIdField(info.getField());
                helper.setIdValue(fo);
                primaryKey = new Pair(info, fo);
            }
            if (info.getPrimaryKey().booleanValue() && updateNull || fo == null && !updateNull && !ncs.contains(info.getColumnName()) || databaseType != null && databaseType.contains("SERVER") && info.getColumnType() == ColumnType.TIMESTAMP) continue;
            if (fo != null) {
                Pair pair = SQLHelperCreator.handleObject(obj, info, fo);
                sets.add(info.getColumnName() + " = ? ");
                parameters.add(pair);
                continue;
            }
            if (!updateNull && !ncs.contains(info.getColumnName())) continue;
            sets.add(info.getColumnName() + " = NULL ");
        }
        sql.append(ORMUtils.join(sets, ", "));
        sql.append(" WHERE ");
        String conditions = null;
        if (condition != null) {
            conditions = option.getConditions(clazz, ORMUtils.newList(condition), parameters);
        }
        if (ORMUtils.isEmpty(conditions)) {
            throw new ORMException("Update table terms is empty, Class[" + clazz.getName() + "], value[" + obj + "]");
        }
        sql.append(conditions);
        helper.setPair(primaryKey);
        helper.setSql(sql.toString());
        helper.setParameters(parameters);
        return helper;
    }

    public static SQLHelper update(Options option, Object obj, Expression[] expressions, boolean updateNull, String[] nullColumns) {
        ArrayList<String> ncs = new ArrayList<String>();
        if (nullColumns != null && nullColumns.length > 0) {
            ncs.addAll(Arrays.asList(nullColumns));
        }
        Class<?> clazz = obj.getClass();
        String tableName = ORMUtils.getTableName(clazz);
        StringBuffer sql = new StringBuffer("UPDATE ");
        sql.append(tableName);
        sql.append(" SET ");
        ArrayList<Pair> parameters = new ArrayList<Pair>();
        ArrayList<String> sets = new ArrayList<String>();
        Pair primaryKey = null;
        List<ColumnInfo> infoList = ORMUtils.getColumnInfo(clazz);
        ORMUtils.whenTrue(infoList == null, "Get columns cache is empty.");
        String databaseType = DatabaseTypeHolder.get();
        SQLHelper helper = new SQLHelper();
        for (ColumnInfo info : infoList) {
            Object fo = ORMUtils.getFieldValue(obj, info);
            if (info.getPrimaryKey().booleanValue()) {
                helper.setIdField(info.getField());
                helper.setIdValue(fo);
            }
            if (fo == null && !updateNull && !ncs.contains(info.getColumnName())) continue;
            if (info.getPrimaryKey().booleanValue()) {
                primaryKey = new Pair(info, fo);
                continue;
            }
            if (databaseType != null && databaseType.contains("SERVER") && info.getColumnType() == ColumnType.TIMESTAMP) continue;
            if (fo != null) {
                Pair pair = SQLHelperCreator.handleObject(obj, info, fo);
                if (info.getPrimaryKey().booleanValue() && pair.getValue() != null) {
                    helper.setIdValue(pair.getValue());
                }
                sets.add(info.getColumnName() + " = ? ");
                parameters.add(pair);
                continue;
            }
            if (!updateNull && !ncs.contains(info.getColumnName())) continue;
            sets.add(info.getColumnName() + " = NULL ");
        }
        sql.append(ORMUtils.join(sets, ", "));
        sql.append(" WHERE ");
        if (primaryKey != null && primaryKey.getValue() != null) {
            if (expressions != null && expressions.length > 0) {
                throw new ORMException("Update table with primary key, shout not add expresses, Class[" + clazz.getName() + "], value[" + obj + "]");
            }
            sql.append(primaryKey.getColumn() + " = ? ");
            parameters.add(primaryKey);
        } else {
            if (expressions == null || expressions.length == 0) {
                throw new ORMException("Update table without primary key, but expresses is empty, Class[" + clazz.getName() + "], value[" + obj + "]");
            }
            ArrayList<String> terms = new ArrayList<String>();
            for (Expression expression : expressions) {
                SQLPair pair;
                if (expression == null || (pair = option.parseExpression(clazz, expression)) == null) continue;
                terms.add(pair.getSql());
                parameters.addAll(pair.getPairs());
            }
            sql.append(ORMUtils.join(terms, " AND "));
        }
        helper.setPair(primaryKey);
        helper.setSql(sql.toString());
        helper.setParameters(parameters);
        return helper;
    }

    public static SQLHelper updateExpress(Class<?> clazz, Options options, Expression[] values, Expression[] conditions) {
        SQLPair pair;
        ArrayList<String> terms;
        String tableName = ORMUtils.getTableName(clazz);
        StringBuffer sql = new StringBuffer("UPDATE ");
        sql.append(tableName);
        sql.append(" SET ");
        ArrayList<Pair> parameters = new ArrayList<Pair>();
        List<ColumnInfo> infoList = ORMUtils.getColumnInfo(clazz);
        ORMUtils.whenTrue(infoList == null, "Get columns cache is empty.");
        SQLHelper helper = new SQLHelper();
        if (values != null) {
            terms = new ArrayList<String>();
            for (Expression expression : values) {
                if (expression == null || (pair = options.parseExpression(clazz, expression)) == null) continue;
                terms.add(pair.getSql());
                parameters.addAll(pair.getPairs());
            }
            if (!terms.isEmpty()) {
                sql.append(ORMUtils.join(terms, " , "));
            } else {
                throw new ORMException("Update values is empty, Class[" + clazz.getName() + "]");
            }
        }
        if (conditions != null) {
            terms = new ArrayList();
            for (Expression expression : conditions) {
                if (expression == null || (pair = options.parseExpression(clazz, expression)) == null) continue;
                terms.add(pair.getSql());
                parameters.addAll(pair.getPairs());
            }
            if (!terms.isEmpty()) {
                sql.append(" WHERE ");
                sql.append(ORMUtils.join(terms, " AND "));
            }
        }
        helper.setSql(sql.toString());
        helper.setParameters(parameters);
        return helper;
    }

    public static SQLHelper insert(Object obj, Options options) {
        Class<?> clazz = obj.getClass();
        String tableName = ORMUtils.getTableName(clazz);
        StringBuffer sql = new StringBuffer("INSERT INTO ");
        sql.append(tableName);
        sql.append("(");
        ArrayList<Pair> parameters = new ArrayList<Pair>();
        ArrayList<String> ps = new ArrayList<String>();
        ArrayList<String> vs = new ArrayList<String>();
        SQLHelper helper = new SQLHelper();
        List<ColumnInfo> infoList = ORMUtils.getColumnInfo(clazz);
        ORMUtils.whenTrue(infoList == null, "Get columns cache is empty.");
        String databaseType = DatabaseTypeHolder.get();
        for (ColumnInfo info : infoList) {
            Object fo = ORMUtils.getFieldValue(obj, info);
            if (databaseType != null && databaseType.contains("SERVER") && info.getColumnType() == ColumnType.TIMESTAMP) continue;
            if (info.getPrimaryKey().booleanValue()) {
                fo = SQLHelperCreator.createPrimaryKeyValue(options, helper, ps, vs, info, obj, fo);
            }
            if (fo == null) continue;
            Pair pair = SQLHelperCreator.handleObject(obj, info, fo);
            if (info.getPrimaryKey().booleanValue() && pair.getValue() != null) {
                helper.setIdValue(pair.getValue());
            }
            ps.add(info.getColumnName());
            vs.add("?");
            parameters.add(pair);
        }
        if (ps.size() == 0) {
            throw new ORMException("Insert into table without values, Class[" + clazz.getName() + "], value[" + obj + "]");
        }
        sql.append(ORMUtils.join(ps, ","));
        sql.append(") VALUES (");
        sql.append(ORMUtils.join(vs, ","));
        sql.append(")");
        helper.setSql(sql.toString());
        helper.setParameters(parameters);
        return helper;
    }

    private static Pair handleObject(Object obj, ColumnInfo info, Object fo) {
        Pair result = new Pair(info, fo);
        RdConvert serializer = info.getField().getAnnotation(RdConvert.class);
        if (serializer != null) {
            Pair kvObject;
            IColumnConvert ser = columnConvertMap.get(serializer.value());
            if (ser == null) {
                try {
                    ser = serializer.value().newInstance();
                    columnConvertMap.put(serializer.value(), ser);
                }
                catch (InstantiationException e) {
                    throw new ORMException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ORMException(e);
                }
            }
            if (ser != null && (kvObject = ser.setValueHandle(obj, info, fo)) != null) {
                result = kvObject;
            }
        }
        return result;
    }

    public static Object createPrimaryKeyValue(Options options, SQLHelper helper, List<String> ps, List<String> vs, ColumnInfo info, Object obj, Object fo) {
        if (ORMUtils.isEmpty(fo)) {
            RdId rdId = info.getField().getAnnotation(RdId.class);
            helper.setIdField(info.getField());
            if (rdId.autoIncrement()) {
                if (!ORMUtils.isEmpty(rdId.sequence()) && options instanceof OracleOptions) {
                    ps.add(info.getColumnName());
                    vs.add(rdId.sequence() + ".nextval");
                }
            } else {
                Class<? extends IDGenerator> generatorClass = rdId.generator();
                if (IDGenerator.class.isAssignableFrom(generatorClass)) {
                    IDGenerator generator = generatorMap.get(generatorClass.getName());
                    if (generator == null) {
                        try {
                            generator = generatorClass.newInstance();
                            generatorMap.put(generatorClass.getName(), generator);
                        }
                        catch (InstantiationException instantiationException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                    fo = generator.next(obj, info.getField().getType(), fo);
                    ORMUtils.setFieldValue(obj, info, fo);
                    helper.setIdValue(fo);
                }
            }
        } else {
            helper.setIdValue(fo);
        }
        return fo;
    }

    public static <S> List<SQLHelper> inserts(List<S> objs, Options options) {
        ArrayList<SQLHelper> helpers = new ArrayList<SQLHelper>();
        if (objs == null || objs.isEmpty()) {
            return helpers;
        }
        String insertSQL = null;
        Class<?> clazz = null;
        for (S obj : objs) {
            if (clazz == null) {
                clazz = obj.getClass();
            } else if (!clazz.equals(obj.getClass())) {
                throw new ORMException("Error class, [" + clazz.getName() + "] but [" + obj.getClass() + "]");
            }
            String tableName = ORMUtils.getTableName(clazz);
            ArrayList<Pair> parameters = new ArrayList<Pair>();
            ArrayList<String> ps = new ArrayList<String>();
            ArrayList<String> vs = new ArrayList<String>();
            SQLHelper helper = new SQLHelper();
            List<ColumnInfo> infoList = ORMUtils.getColumnInfo(clazz);
            ORMUtils.whenTrue(infoList == null, "Get columns cache is empty.");
            String databaseType = DatabaseTypeHolder.get();
            for (ColumnInfo info : infoList) {
                Object fo = ORMUtils.getFieldValue(obj, info);
                if (databaseType != null && databaseType.contains("SERVER") && info.getColumnType() == ColumnType.TIMESTAMP) continue;
                if (info.getPrimaryKey().booleanValue()) {
                    fo = SQLHelperCreator.createPrimaryKeyValue(options, helper, ps, vs, info, obj, fo);
                }
                Pair pair = SQLHelperCreator.handleObject(obj, info, fo);
                if (info.getPrimaryKey().booleanValue() && pair.getValue() != null) {
                    helper.setIdValue(pair.getValue());
                }
                ps.add(info.getColumnName());
                vs.add("?");
                parameters.add(pair);
            }
            if (insertSQL == null) {
                StringBuffer sql = new StringBuffer("INSERT INTO ");
                sql.append(tableName);
                sql.append("(");
                sql.append(ORMUtils.join(ps, ","));
                sql.append(") VALUES (");
                sql.append(ORMUtils.join(vs, ","));
                sql.append(")");
                insertSQL = sql.toString();
            }
            helper.setSql(insertSQL);
            helper.setParameters(parameters);
            helpers.add(helper);
        }
        return helpers;
    }

    public static <S> List<SQLHelper> updates(List<S> objs, List<String> columns) {
        ArrayList<SQLHelper> helpers = new ArrayList<SQLHelper>();
        if (objs == null || objs.isEmpty()) {
            return helpers;
        }
        String updateSQL = null;
        Class<?> clazz = null;
        ArrayList<ColumnInfo> selected = null;
        for (S obj : objs) {
            if (clazz == null) {
                clazz = obj.getClass();
            } else if (!clazz.equals(obj.getClass())) {
                throw new ORMException("Error class, [" + clazz.getName() + "] but [" + obj.getClass() + "]");
            }
            String tableName = ORMUtils.getTableName(clazz);
            ArrayList<Pair> parameters = new ArrayList<Pair>();
            SQLHelper helper = new SQLHelper();
            ColumnInfo primaryKey = null;
            if (selected == null) {
                ArrayList<String> ps = new ArrayList<String>();
                selected = new ArrayList<ColumnInfo>();
                List<ColumnInfo> infoList = ORMUtils.getColumnInfo(clazz);
                ORMUtils.whenTrue(infoList == null, "Get columns cache is empty.");
                String databaseType = DatabaseTypeHolder.get();
                for (ColumnInfo info : infoList) {
                    if (databaseType != null && databaseType.contains("SERVER") && info.getColumnType() == ColumnType.TIMESTAMP) continue;
                    if (info.getPrimaryKey().booleanValue()) {
                        primaryKey = info;
                        continue;
                    }
                    if (columns != null) {
                        if (!columns.contains(info.getColumnName())) continue;
                        selected.add(info);
                        continue;
                    }
                    selected.add(info);
                }
                ORMUtils.whenTrue(primaryKey == null, "No primary key for table : " + clazz);
                ORMUtils.whenTrue(selected.isEmpty(), "No valid column for table : " + clazz);
                StringBuffer sql = new StringBuffer("UPDATE ");
                sql.append(tableName);
                sql.append(" SET ");
                for (ColumnInfo info : selected) {
                    if (databaseType != null && databaseType.contains("SERVER") && info.getColumnType() == ColumnType.TIMESTAMP) continue;
                    ps.add(String.format(" %s = ? ", info.getColumnName()));
                }
                selected.add(primaryKey);
                sql.append(ORMUtils.join(ps, ","));
                sql.append(String.format(" WHERE %s = ? ", primaryKey.getColumnName()));
                updateSQL = sql.toString();
            }
            for (ColumnInfo info : selected) {
                Object fo = ORMUtils.getFieldValue(obj, info);
                Pair pair = SQLHelperCreator.handleObject(obj, info, fo);
                parameters.add(pair);
            }
            helper.setSql(updateSQL);
            helper.setParameters(parameters);
            helpers.add(helper);
        }
        return helpers;
    }

    public static SQLHelper get(Object obj, String ... names) {
        Class<?> clazz = obj.getClass();
        String tableName = ORMUtils.getTableName(clazz);
        StringBuffer sql = new StringBuffer("SELECT ");
        String nameStr = ORMUtils.join(names, ",");
        if (ORMUtils.isEmpty(nameStr)) {
            sql.append("*");
        } else {
            sql.append(nameStr);
        }
        sql.append(" FROM ");
        sql.append(tableName);
        ArrayList<Pair> parameters = new ArrayList<Pair>();
        ArrayList<String> ps = new ArrayList<String>();
        Pair primaryKey = null;
        List<ColumnInfo> infoList = ORMUtils.getColumnInfo(clazz);
        ORMUtils.whenTrue(infoList == null, "Get columns cache is empty.");
        for (ColumnInfo info : infoList) {
            Object fo = ORMUtils.getFieldValue(obj, info);
            if (fo == null) continue;
            Pair pair = SQLHelperCreator.handleObject(obj, info, fo);
            if (info.getPrimaryKey().booleanValue()) {
                primaryKey = pair;
                break;
            }
            ps.add(info.getColumnName() + " = ? ");
            parameters.add(pair);
        }
        if (primaryKey != null) {
            sql.append(" WHERE ");
            sql.append(primaryKey.getColumn() + " = ? ");
            parameters.clear();
            parameters.add(primaryKey);
        } else if (ps.size() > 0) {
            sql.append(" WHERE " + ORMUtils.join(ps, " AND "));
        }
        SQLHelper helper = new SQLHelper();
        helper.setSql(sql.toString());
        helper.setParameters(parameters);
        return helper;
    }

    public static SQLHelper query(Options options, Class<?> clazz, Expression[] expressions) {
        String tableName = ORMUtils.getTableName(clazz);
        StringBuffer sql = new StringBuffer("SELECT * FROM " + tableName);
        ArrayList<Pair> values = new ArrayList<Pair>();
        String conditions = options.getConditions(clazz, expressions, values);
        if (!ORMUtils.isEmpty(conditions)) {
            sql.append(" WHERE " + conditions);
        }
        SQLHelper helper = new SQLHelper();
        helper.setSql(sql.toString());
        helper.setParameters(values);
        return helper;
    }

    public static SQLHelper queryCountExpress(Options options, Class<?> clazz, Expression ... expressions) {
        String tableName = ORMUtils.getTableName(clazz);
        StringBuffer sql = new StringBuffer("SELECT COUNT(*) FROM " + tableName);
        ArrayList<Pair> values = new ArrayList<Pair>();
        String conditions = options.getConditions(clazz, expressions, values);
        if (!ORMUtils.isEmpty(conditions)) {
            sql.append(" WHERE " + conditions);
        }
        SQLHelper helper = new SQLHelper();
        helper.setSql(sql.toString());
        helper.setParameters(values);
        return helper;
    }

    public static SQLHelper queryCount(Options options, Class<?> clazz, Condition condition) {
        String tableName = ORMUtils.getTableName(clazz);
        StringBuffer sql = new StringBuffer("SELECT COUNT(*) FROM " + tableName);
        ArrayList<Pair> values = new ArrayList<Pair>();
        String conditions = options.getConditions(clazz, ORMUtils.newList(condition), values);
        if (!ORMUtils.isEmpty(conditions)) {
            sql.append(" WHERE " + conditions);
        }
        SQLHelper helper = new SQLHelper();
        helper.setSql(sql.toString());
        helper.setParameters(values);
        return helper;
    }

    public static SQLHelper get(Class clazz, Object id) {
        String tableName = ORMUtils.getTableName(clazz);
        StringBuffer sql = new StringBuffer("SELECT * ");
        sql.append("FROM ");
        sql.append(tableName);
        sql.append(" WHERE ");
        Pair primaryKey = null;
        ArrayList<Pair> parameters = new ArrayList<Pair>();
        List<ColumnInfo> infoList = ORMUtils.getColumnInfo(clazz);
        ORMUtils.whenTrue(infoList == null, "Get columns cache is empty.");
        for (ColumnInfo info : infoList) {
            if (!info.getPrimaryKey().booleanValue() || id == null) continue;
            primaryKey = SQLHelperCreator.handleObject(null, info, id);
            break;
        }
        if (primaryKey == null) {
            throw new ORMException("Select table without primary key, Class[" + clazz.getName() + "], value[" + id + "]");
        }
        sql.append(primaryKey.getColumn() + " = ? ");
        parameters.add(primaryKey);
        SQLHelper helper = new SQLHelper();
        helper.setSql(sql.toString());
        helper.setParameters(parameters);
        return helper;
    }

    private static <T> T parse(IQueryConvert queryConvert, Object value, Class distClass) throws SQLException {
        Object object = null;
        if (queryConvert != null) {
            object = queryConvert.queryValueHandle(value, distClass);
        }
        return (T)object;
    }

    private static KV parseMap(IQueryConvert queryConvert, Map<String, Object> tempMap, Object value, Class distClass) throws SQLException {
        KV object = null;
        if (queryConvert != null) {
            object = queryConvert.queryValueHandleMap(tempMap, value, distClass);
        }
        return object;
    }

    private static <T> T parseObject(IColumnConvert columnConvert, Object result, Object value, ColumnInfo columnInfo) throws SQLException {
        Object object = null;
        if (columnConvert != null) {
            object = columnConvert.getValueHandle(result, columnInfo, value);
        }
        return (T)object;
    }

    private static <T> T parseObject(IQueryConvert queryConvert, Object result, Object value, ColumnInfo columnInfo) throws SQLException {
        Object object = null;
        if (queryConvert != null) {
            object = queryConvert.queryValueHandle(result, columnInfo, value);
        }
        return (T)object;
    }

    public static <T> T newClass(Class clazz, ResultSet rs, IResultSetHandler resultSetHandler) throws IllegalAccessException, SQLException {
        return SQLHelperCreator.newClass(clazz, rs, null, resultSetHandler);
    }

    public static <T> T newClass(Class clazz, ResultSet rs, IQueryConvert queryConvert, IResultSetHandler resultSetHandler) throws IllegalAccessException, SQLException {
        T parser;
        ResultSetMetaData metaMap = rs.getMetaData();
        HashMap<String, Object> t = null;
        DataType type = DataType.getDataType(clazz.getSimpleName());
        Object object = rs.getObject(1);
        if (type != DataType.MAP && type != DataType.UNKNOWN && (parser = SQLHelperCreator.parse(queryConvert, object, clazz)) != null) {
            return parser;
        }
        switch (type) {
            case STRING: {
                if (object == null) break;
                t = object.toString();
                break;
            }
            case INTEGER: {
                t = new Integer(rs.getInt(1));
                break;
            }
            case LONG: {
                t = new Long(rs.getLong(1));
                break;
            }
            case FLOAT: {
                t = new Float(rs.getFloat(1));
                break;
            }
            case DOUBLE: {
                t = new Double(rs.getDouble(1));
                break;
            }
            case SHORT: {
                t = new Short(rs.getShort(1));
                break;
            }
            case BYTE: {
                t = new Byte(rs.getByte(1));
                break;
            }
            case BOOLEAN: {
                t = new Boolean(rs.getBoolean(1));
                break;
            }
            case MAP: {
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                for (int i = 1; i <= metaMap.getColumnCount(); ++i) {
                    Object obj = rs.getObject(i);
                    KV kv = SQLHelperCreator.parseMap(queryConvert, tempMap, object, clazz);
                    if (kv != null) {
                        tempMap.put(kv.getKey(), kv.getValue());
                        continue;
                    }
                    kv = resultSetHandler.parseMap(metaMap, i, obj, rs);
                    if (kv == null) continue;
                    tempMap.put(kv.getKey(), kv.getValue());
                }
                t = tempMap;
                break;
            }
            case UNKNOWN: {
                ResultSetMetaData meta = rs.getMetaData();
                HashMap<String, Object> temp = new HashMap<String, Object>();
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    String label = meta.getColumnLabel(i);
                    String name = meta.getColumnName(i);
                    Object value = rs.getObject(label);
                    String tmp = QueryUtils.displayNameOrAsName(label, name);
                    temp.put(tmp, value);
                    temp.put(tmp.toLowerCase(Locale.ROOT), value);
                    temp.put(tmp.toUpperCase(Locale.ROOT), value);
                    temp.put(label.toLowerCase(Locale.ROOT), value);
                    temp.put(label.toUpperCase(Locale.ROOT), value);
                }
                try {
                    t = clazz.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                List<ColumnInfo> infoList = ORMUtils.getColumnInfo(clazz);
                for (ColumnInfo info : infoList) {
                    SQLHelperCreator.handleInfo(rs, queryConvert, resultSetHandler, t, temp, info);
                }
                List<ColumnInfo> fields = ORMUtils.getExtendFields(clazz);
                for (ColumnInfo info : fields) {
                    SQLHelperCreator.handleInfo(rs, queryConvert, resultSetHandler, t, temp, info);
                }
                break;
            }
        }
        return (T)t;
    }

    private static <T> void handleInfo(ResultSet rs, IQueryConvert queryConvert, IResultSetHandler resultSetHandler, T t, Map<String, Object> temp, ColumnInfo info) throws SQLException {
        Object obj = null;
        if (info.getColumnName() != null) {
            obj = temp.get(info.getColumnName());
            if (obj == null) {
                obj = temp.get(info.getColumnName().toUpperCase(Locale.ROOT));
            }
            if (obj == null) {
                obj = temp.get(info.getColumnName().toLowerCase(Locale.ROOT));
            }
        } else {
            obj = temp.get(info.getName());
            if (obj == null) {
                obj = temp.get(info.getName().toUpperCase(Locale.ROOT));
            }
            if (obj == null) {
                obj = temp.get(info.getName().toLowerCase(Locale.ROOT));
            }
        }
        if (obj != null) {
            if ("integer".equalsIgnoreCase(info.getType()) && obj instanceof Boolean) {
                obj = rs.getInt(info.getColumnName());
            }
            boolean done = false;
            Object kvObject = null;
            RdConvert deserializer = info.getField().getAnnotation(RdConvert.class);
            if (deserializer != null) {
                IColumnConvert des = columnConvertMap.get(deserializer.value());
                if (des == null) {
                    try {
                        des = deserializer.value().newInstance();
                        columnConvertMap.put(deserializer.value(), des);
                    }
                    catch (InstantiationException e) {
                        throw new ORMException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ORMException(e);
                    }
                }
                if (des != null && (kvObject = SQLHelperCreator.parseObject(des, t, obj, info)) != null) {
                    T tempKvObject = SQLHelperCreator.parseObject(queryConvert, t, obj, info);
                    if (tempKvObject != null) {
                        ORMUtils.setFieldValue(t, info, tempKvObject);
                    } else {
                        ORMUtils.setFieldValue(t, info, kvObject);
                    }
                    done = true;
                }
            }
            if (!done && (kvObject = SQLHelperCreator.parseObject(queryConvert, t, obj, info)) != null) {
                ORMUtils.setFieldValue(t, info, kvObject);
                done = true;
            }
            if (!done) {
                resultSetHandler.handle(t, info, obj, rs);
            }
        }
    }

    public static void setParameter(Options options, PreparedStatement ps, List<Pair> objects, Connection connection) throws SQLException {
        if (options == null) {
            return;
        }
        String databaseType = DatabaseTypeHolder.get();
        for (int i = 0; i < objects.size(); ++i) {
            Pair pair = objects.get(i);
            options.setParameter(ps, connection, databaseType, i, pair);
        }
    }
}

