/*
 * Decompiled with CFR 0.152.
 */
package com.powerupsoftwareengineering.java.immutable.model.sample;

import com.powerupsoftwareengineering.java.immutable.model.ModelObjectAbs;
import com.powerupsoftwareengineering.java.immutable.model.builder.validator.BuilderValidator;
import com.powerupsoftwareengineering.java.immutable.model.builder.validator.MandatoryIntBuilderValidator;
import com.powerupsoftwareengineering.java.immutable.model.builder.validator.MandatoryStringBuilderValidator;
import com.powerupsoftwareengineering.java.immutable.model.parameter.validator.SoftLengthRestrictionStringParameterValidator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class SampleModelObject
extends ModelObjectAbs {
    public static final int NAME_MAX_LENGTH = 256;
    private final String name;
    private final int order;

    private SampleModelObject(Builder builder) {
        super((ModelObjectAbs.Builder)builder);
        this.name = builder.name;
        this.order = builder.order;
    }

    public String getName() {
        return this.name;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SampleModelObject that = (SampleModelObject)((Object)o);
        return new EqualsBuilder().append((Object)this.name, (Object)that.name).append(this.order, that.order).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append(this.order).toHashCode();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this), (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public static final class Builder
    extends ModelObjectAbs.Builder<SampleModelObject> {
        private static final String NAME_FIELD_NAME = "Name";
        private String name;
        private int order;
        private final SoftLengthRestrictionStringParameterValidator nameParameterValidator;

        public Builder() {
            this.addValidator((BuilderValidator)new MandatoryStringBuilderValidator(NAME_FIELD_NAME, this::getName));
            this.addValidator((BuilderValidator)new MandatoryIntBuilderValidator("Order", this::getOrder));
            this.nameParameterValidator = new SoftLengthRestrictionStringParameterValidator(NAME_FIELD_NAME, 256);
        }

        public SampleModelObject build() {
            this.validate();
            return new SampleModelObject(this);
        }

        public void reset() {
            super.reset();
            this.name = null;
            this.order = 0;
        }

        public void copyValues(SampleModelObject sampleModelObject) {
            super.copyValues((ModelObjectAbs)sampleModelObject);
            this.setValues(sampleModelObject);
        }

        public void setValues(SampleModelObject sampleModelObject) {
            super.setValues((ModelObjectAbs)sampleModelObject);
            this.name = sampleModelObject.getName();
            this.order = sampleModelObject.getOrder();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = this.nameParameterValidator.validate(name);
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }
    }
}

