/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.lexer;

import com.scriptbasic.errors.BasicInterpreterInternalError;
import com.scriptbasic.exceptions.BasicLexicalException;
import com.scriptbasic.exceptions.GenericSyntaxException;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.Factory;
import com.scriptbasic.interfaces.HierarchicalReader;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.interfaces.LexicalElementAnalyzer;
import com.scriptbasic.interfaces.LineOrientedLexicalAnalyzer;
import com.scriptbasic.interfaces.Reader;
import com.scriptbasic.interfaces.SourceProvider;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import com.scriptbasic.readers.GenericHierarchicalReader;
import com.scriptbasic.utility.CharUtils;
import java.io.IOException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;

public class BasicLexicalAnalyzer
implements LineOrientedLexicalAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(BasicLexicalAnalyzer.class);
    private Reader reader;
    private Factory factory;
    private final Deque<LexicalElementAnalyzer> analyzerQueue = new LinkedList<LexicalElementAnalyzer>();
    private Deque<LexicalElement> lexicalElementQueue = new LinkedList<LexicalElement>();
    private Iterator<LexicalElement> lexicalElementQueueIterator = this.lexicalElementQueue.iterator();
    private LexicalElement peekElement = null;

    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    protected BasicLexicalAnalyzer() {
        LOG.debug("constructor created {}", this);
    }

    @Override
    public void set(Reader reader) {
        this.reader = reader;
        for (LexicalElementAnalyzer lea : this.analyzerQueue) {
            lea.setReader(reader);
        }
    }

    @Override
    public void registerElementAnalyzer(LexicalElementAnalyzer lea) {
        LOG.debug("lexical element analyzer {} was registered", lea);
        lea.setReader(this.reader);
        this.analyzerQueue.add(lea);
    }

    @Override
    public void resetLine() {
        this.lexicalElementQueueIterator = this.lexicalElementQueue.iterator();
    }

    private void emptyLexicalElementQueue() {
        this.lexicalElementQueue = new LinkedList<LexicalElement>();
    }

    @Override
    public LexicalElement get() throws AnalysisException {
        LexicalElement le = null;
        le = this.peek();
        this.peekElement = null;
        return le;
    }

    @Override
    public LexicalElement peek() throws AnalysisException {
        if (this.peekElement == null) {
            if (!this.lexicalElementQueueIterator.hasNext()) {
                this.readTheNextLine();
                this.resetLine();
            }
            if (!this.lexicalElementQueue.isEmpty()) {
                this.peekElement = this.lexicalElementQueueIterator.next();
            }
        }
        return this.peekElement;
    }

    private Integer skipWhiteSpaces(Integer firstCharacter) {
        Integer characterToSkip = firstCharacter;
        while (characterToSkip != null && CharUtils.isWhitespace(characterToSkip) && !CharUtils.isNewLine(characterToSkip)) {
            characterToSkip = this.reader.get();
        }
        return characterToSkip;
    }

    private static boolean stringIsIncludeOrImport(String s) {
        return s.equalsIgnoreCase("INCLUDE") || s.equalsIgnoreCase("IMPORT");
    }

    private static boolean isIncludeOrImport(LexicalElement le) {
        return (le.isSymbol() != false || le.isIdentifier() != false) && BasicLexicalAnalyzer.stringIsIncludeOrImport(le.getLexeme());
    }

    private void readTheNextLine() throws AnalysisException {
        Boolean lineEndFound = false;
        this.emptyLexicalElementQueue();
        Integer character = this.reader.get();
        while (character != null && !lineEndFound.booleanValue()) {
            LexicalElement le = null;
            character = this.skipWhiteSpaces(character);
            lineEndFound = CharUtils.isNewLine(character);
            if (character != null) {
                this.reader.pushBack(character);
                boolean analyzed = false;
                for (LexicalElementAnalyzer lea : this.analyzerQueue) {
                    le = lea.read();
                    if (le == null) continue;
                    analyzed = true;
                    LOG.debug("{} could analyze the characters", lea);
                    LOG.debug("the result is: {}", le.toString());
                    this.lexicalElementQueue.add(le);
                    break;
                }
                if (!analyzed) {
                    LOG.error("None of the lexical analyzers could analyze the line");
                    throw new BasicInterpreterInternalError("no lexical element analyzer could analyze the input");
                }
            }
            character = this.reader.get();
        }
        this.reader.pushBack(character);
        if (this.reader instanceof HierarchicalReader) {
            this.processSourceInclude();
        }
    }

    private void processSourceInclude() throws AnalysisException {
        LexicalElement lexicalElement;
        this.resetLine();
        GenericHierarchicalReader hreader = (GenericHierarchicalReader)this.reader;
        if (!this.lexicalElementQueue.isEmpty() && BasicLexicalAnalyzer.isIncludeOrImport(lexicalElement = this.lexicalElementQueueIterator.next())) {
            lexicalElement = this.lexicalElementQueueIterator.next();
            if (lexicalElement.isString().booleanValue()) {
                LexicalElement newLine = this.lexicalElementQueueIterator.next();
                if (newLine == null || !newLine.isLineTerminator().booleanValue()) {
                    LOG.error("There are extra characters on the line after the include file name string");
                    throw new GenericSyntaxException("There are extra chars at the end of the INCLUDE statement");
                }
                SourceProvider sp = hreader.getSourceProvider();
                Reader childReader = null;
                try {
                    childReader = sp.get(lexicalElement.stringValue(), hreader.getFileName());
                }
                catch (IllegalArgumentException e) {
                    LOG.error("", e);
                }
                catch (IOException e) {
                    throw new BasicLexicalException("Can not open included file '" + lexicalElement.stringValue() + "'", e);
                }
                hreader.include(childReader);
                this.emptyLexicalElementQueue();
                this.readTheNextLine();
                this.resetLine();
            } else {
                LOG.error("This is not a string following the keyword INCLUDE");
                throw new GenericSyntaxException("String has to be used after import or include.");
            }
        }
    }
}

