/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.commands;

import com.scriptbasic.exceptions.GenericSyntaxException;
import com.scriptbasic.executors.commands.CommandCall;
import com.scriptbasic.executors.leftvalues.BasicLeftValue;
import com.scriptbasic.executors.rightvalues.FunctionCall;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.Command;
import com.scriptbasic.interfaces.ExpressionList;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.syntax.commands.AbstractCommandAnalyzer;
import com.scriptbasic.utility.FactoryUtility;

public class CommandAnalyzerCall
extends AbstractCommandAnalyzer {
    @Override
    public Command analyze() throws AnalysisException {
        CommandCall node = new CommandCall();
        LexicalAnalyzer lexicalAnalyzer = FactoryUtility.getLexicalAnalyzer(this.getFactory());
        LexicalElement lexicalElement = lexicalAnalyzer.peek();
        if (lexicalElement != null && lexicalElement.isSymbol(this.getName()).booleanValue()) {
            lexicalAnalyzer.get();
        }
        FunctionCall functionCall = new FunctionCall();
        functionCall.setVariableName(((BasicLeftValue)FactoryUtility.getSimpleLeftValueAnalyzer(this.getFactory()).analyze()).getIdentifier());
        lexicalElement = lexicalAnalyzer.peek();
        boolean needClosing = false;
        if (lexicalElement != null && lexicalElement.isSymbol("(").booleanValue()) {
            lexicalAnalyzer.get();
            needClosing = true;
            lexicalElement = lexicalAnalyzer.peek();
        }
        if (needClosing && lexicalElement != null && !lexicalElement.isSymbol(")").booleanValue() || !needClosing && lexicalElement != null && !lexicalElement.isSymbol("\n").booleanValue()) {
            functionCall.setExpressionList((ExpressionList)FactoryUtility.getExpressionListAnalyzer(this.getFactory()).analyze());
        } else {
            functionCall.setExpressionList(null);
        }
        if (needClosing) {
            lexicalElement = lexicalAnalyzer.peek();
            if (lexicalElement != null && lexicalElement.isSymbol(")").booleanValue()) {
                lexicalAnalyzer.get();
            } else {
                throw new GenericSyntaxException("The closing ) is missing after the CALL statement");
            }
        }
        this.consumeEndOfLine();
        node.setFunctionCall(functionCall);
        return node;
    }

    @Override
    protected String getName() {
        return "CALL";
    }
}

