/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility;

import com.scriptbasic.exceptions.GenericSyntaxException;
import com.scriptbasic.executors.operators.JavaObjectFieldAccessOperator;
import com.scriptbasic.executors.rightvalues.BasicStringValue;
import com.scriptbasic.executors.rightvalues.VariableAccess;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.ExpressionList;
import com.scriptbasic.interfaces.ExtendedInterpreter;
import com.scriptbasic.interfaces.RightValue;
import com.scriptbasic.utility.CastUtility;
import com.scriptbasic.utility.RightValueUtility;
import com.scriptbasic.utility.UtilityUtility;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class ExpressionUtility {
    private ExpressionUtility() {
        UtilityUtility.throwExceptionToEnsureNobodyCallsIt();
    }

    private static boolean parameterLengthMatch(Class<?>[] parameterTypes, List<RightValue> args) {
        if (args == null) {
            return parameterTypes.length == 0;
        }
        return parameterTypes.length == args.size();
    }

    public static Object[] getObjectArray(List<RightValue> args, Method method, ExtendedInterpreter extendedInterpreter) throws ExecutionException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (!ExpressionUtility.parameterLengthMatch(parameterTypes, args)) {
            throw new BasicRuntimeException("Different number of parameters calling the Java method '" + method.getName() + "'");
        }
        ArrayList<Object> result = null;
        if (args != null) {
            result = new ArrayList<Object>();
            int parameterIndex = 0;
            for (RightValue arg : args) {
                Object object = CastUtility.cast(RightValueUtility.getValueObject(arg), parameterTypes[parameterIndex]);
                result.add(object);
                ++parameterIndex;
            }
        }
        return result == null ? null : result.toArray(new Object[0]);
    }

    public static List<RightValue> evaluateExpressionList(ExtendedInterpreter extendedInterpreter, ExpressionList expressionList) throws ExecutionException {
        LinkedList<RightValue> args = null;
        if (expressionList != null) {
            args = new LinkedList<RightValue>();
            for (Expression expression : expressionList) {
                args.add(expression.evaluate(extendedInterpreter));
            }
        }
        return args;
    }

    public static String convertToString(Expression expression) throws AnalysisException {
        if (expression instanceof VariableAccess) {
            return ((VariableAccess)expression).getVariableName();
        }
        if (expression instanceof JavaObjectFieldAccessOperator) {
            JavaObjectFieldAccessOperator ofao = (JavaObjectFieldAccessOperator)expression;
            return ExpressionUtility.convertToString(ofao.getLeftOperand()) + "." + ExpressionUtility.convertToString(ofao.getRightOperand());
        }
        if (expression instanceof BasicStringValue) {
            return (String)((BasicStringValue)expression).getValue();
        }
        throw new GenericSyntaxException("class, package or symbol name are not vaid in command USE");
    }
}

