/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.lexer;

import com.scriptbasic.errors.BasicInterpreterInternalError;
import com.scriptbasic.exceptions.BasicLexicalException;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BasicSyntaxException;
import com.scriptbasic.interfaces.HierarchicalSourceReader;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.interfaces.LexicalElementAnalyzer;
import com.scriptbasic.interfaces.LineOrientedLexicalAnalyzer;
import com.scriptbasic.interfaces.SourceProvider;
import com.scriptbasic.interfaces.SourceReader;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import com.scriptbasic.utility.CharUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BasicLexicalAnalyzer
implements LineOrientedLexicalAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger();
    private final List<LexicalElementAnalyzer> analyzers = new LinkedList<LexicalElementAnalyzer>();
    private final SourceReader reader;
    private List<LexicalElement> allElements = new LinkedList<LexicalElement>();
    private Iterator<LexicalElement> elements = this.allElements.iterator();
    private LexicalElement peekElement = null;

    public BasicLexicalAnalyzer(SourceReader reader) {
        this.reader = reader;
        LOG.debug("constructor created {}", this);
    }

    private static boolean stringIsIncludeOrImport(String s) {
        return s.equalsIgnoreCase("INCLUDE") || s.equalsIgnoreCase("IMPORT");
    }

    private static boolean isIncludeOrImport(LexicalElement lexicalElement) {
        return (lexicalElement.isSymbol() != false || lexicalElement.isIdentifier() != false) && BasicLexicalAnalyzer.stringIsIncludeOrImport(lexicalElement.getLexeme());
    }

    @Override
    public void registerElementAnalyzer(LexicalElementAnalyzer lea) {
        LOG.debug("lexical element analyzer {} was registered", lea);
        this.analyzers.add(lea);
    }

    @Override
    public void resetLine() {
        this.elements = this.allElements.iterator();
        this.peekElement = null;
    }

    private void emptyLexicalElementQueue() {
        this.allElements = new LinkedList<LexicalElement>();
    }

    @Override
    public LexicalElement get() throws AnalysisException {
        LexicalElement le = null;
        le = this.peek();
        this.peekElement = null;
        return le;
    }

    @Override
    public LexicalElement peek() throws AnalysisException {
        if (this.peekElement == null) {
            if (!this.elements.hasNext()) {
                this.readTheNextLine();
                this.resetLine();
            }
            if (!this.allElements.isEmpty()) {
                this.peekElement = this.elements.next();
            }
        }
        return this.peekElement;
    }

    private Integer getFirstNonWhitespaceCharacter(SourceReader reader, Integer firstCharacter) {
        Integer characterToSkip = firstCharacter;
        while (characterToSkip != null && CharUtils.isWhitespace(characterToSkip) && !CharUtils.isNewLine(characterToSkip)) {
            characterToSkip = reader.get();
        }
        return characterToSkip;
    }

    private void readTheNextLine() throws AnalysisException {
        Boolean lineEndFound = false;
        this.emptyLexicalElementQueue();
        Integer ch = this.reader.get();
        while (ch != null && !lineEndFound.booleanValue()) {
            ch = this.getFirstNonWhitespaceCharacter(this.reader, ch);
            lineEndFound = CharUtils.isNewLine(ch);
            if (ch != null) {
                this.reader.pushBack(ch);
                boolean analyzed = false;
                for (LexicalElementAnalyzer analyzer : this.analyzers) {
                    LexicalElement element = analyzer.read();
                    if (element == null) continue;
                    analyzed = true;
                    LOG.debug("{} could analyze the characters", analyzer);
                    LOG.debug("the result is: {}", element.toString());
                    this.allElements.add(element);
                    break;
                }
                if (!analyzed) {
                    LOG.error("None of the lexical analyzers could analyze the line");
                    throw new BasicInterpreterInternalError("no lexical element analyzer could analyze the input");
                }
            }
            ch = this.reader.get();
        }
        this.reader.pushBack(ch);
        this.processSourceInclude();
    }

    private void processSourceInclude() throws AnalysisException {
        LexicalElement statement;
        this.resetLine();
        if (!this.allElements.isEmpty() && BasicLexicalAnalyzer.isIncludeOrImport(statement = this.elements.next())) {
            LexicalElement lexicalElement = this.elements.next();
            this.assertIncludeFileIsSpecifiedAsString(lexicalElement);
            this.assertThereAreNoExtraCharactersAtTheEndOfTheLine();
            SourceProvider sourceProvider = this.reader.getSourceProvider();
            SourceReader childReader = null;
            try {
                childReader = sourceProvider.get(lexicalElement.stringValue(), this.reader.getFileName());
            }
            catch (IllegalArgumentException e) {
                LOG.error("", e);
            }
            catch (IOException e) {
                throw new BasicLexicalException("Can not open included file '" + lexicalElement.stringValue() + "'", e);
            }
            if (!(this.reader instanceof HierarchicalSourceReader)) {
                LOG.error("Cannot include or import with normal reader.");
                throw new BasicSyntaxException("INCLUDE or IMPORT is not allowed in this environment.");
            }
            ((HierarchicalSourceReader)this.reader).include(childReader);
            this.emptyLexicalElementQueue();
            this.readTheNextLine();
            this.resetLine();
        }
    }

    private void assertThereAreNoExtraCharactersAtTheEndOfTheLine() throws BasicSyntaxException {
        LexicalElement newLine;
        LexicalElement lexicalElement = newLine = this.elements.hasNext() ? this.elements.next() : null;
        if (newLine != null && !newLine.isLineTerminator().booleanValue()) {
            LOG.error("There are extra characters on the line after the include file name string");
            throw new BasicSyntaxException("There are extra chars at the end of the INCLUDE statement");
        }
    }

    private void assertIncludeFileIsSpecifiedAsString(LexicalElement lexicalElement) throws BasicSyntaxException {
        if (!lexicalElement.isString().booleanValue()) {
            LOG.error("This is not a string following the keyword INCLUDE");
            throw new BasicSyntaxException("String has to be used after import or include.");
        }
    }
}

