/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.commands;

import com.scriptbasic.exceptions.CommandFactoryException;
import com.scriptbasic.exceptions.KeywordNotImplementedException;
import com.scriptbasic.factories.Context;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.Command;
import com.scriptbasic.interfaces.CommandAnalyzer;
import com.scriptbasic.interfaces.CommandFactory;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import com.scriptbasic.syntax.commands.CommandAnalyzerCall;
import com.scriptbasic.syntax.commands.CommandAnalyzerElse;
import com.scriptbasic.syntax.commands.CommandAnalyzerElseIf;
import com.scriptbasic.syntax.commands.CommandAnalyzerEndIf;
import com.scriptbasic.syntax.commands.CommandAnalyzerEndSub;
import com.scriptbasic.syntax.commands.CommandAnalyzerFor;
import com.scriptbasic.syntax.commands.CommandAnalyzerGlobal;
import com.scriptbasic.syntax.commands.CommandAnalyzerIf;
import com.scriptbasic.syntax.commands.CommandAnalyzerLet;
import com.scriptbasic.syntax.commands.CommandAnalyzerLocal;
import com.scriptbasic.syntax.commands.CommandAnalyzerMethod;
import com.scriptbasic.syntax.commands.CommandAnalyzerNext;
import com.scriptbasic.syntax.commands.CommandAnalyzerPrint;
import com.scriptbasic.syntax.commands.CommandAnalyzerReturn;
import com.scriptbasic.syntax.commands.CommandAnalyzerSub;
import com.scriptbasic.syntax.commands.CommandAnalyzerUse;
import com.scriptbasic.syntax.commands.CommandAnalyzerWend;
import com.scriptbasic.syntax.commands.CommandAnalyzerWhile;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class BasicCommandFactory
implements CommandFactory {
    private static final Logger LOG = LoggerFactory.getLogger();
    private final Context ctx;
    private Map<String, CommandAnalyzer> classMap = new HashMap<String, CommandAnalyzer>();
    private List<CommandAnalyzer> classList = new LinkedList<CommandAnalyzer>();

    public BasicCommandFactory(Context ctx) {
        this.ctx = ctx;
        this.registerCommandAnalyzer("while", new CommandAnalyzerWhile(ctx));
        this.registerCommandAnalyzer("wend", new CommandAnalyzerWend(ctx));
        this.registerCommandAnalyzer("if", new CommandAnalyzerIf(ctx));
        this.registerCommandAnalyzer("else", new CommandAnalyzerElse(ctx));
        this.registerCommandAnalyzer("elseif", new CommandAnalyzerElseIf(ctx));
        this.registerCommandAnalyzer("endif", new CommandAnalyzerEndIf(ctx));
        this.registerCommandAnalyzer("use", new CommandAnalyzerUse(ctx));
        this.registerCommandAnalyzer("method", new CommandAnalyzerMethod(ctx));
        this.registerCommandAnalyzer("sub", new CommandAnalyzerSub(ctx));
        this.registerCommandAnalyzer("endsub", new CommandAnalyzerEndSub(ctx));
        this.registerCommandAnalyzer("return", new CommandAnalyzerReturn(ctx));
        this.registerCommandAnalyzer("print", new CommandAnalyzerPrint(ctx));
        this.registerCommandAnalyzer("local", new CommandAnalyzerLocal(ctx));
        this.registerCommandAnalyzer("global", new CommandAnalyzerGlobal(ctx));
        this.registerCommandAnalyzer("call", new CommandAnalyzerCall(ctx));
        this.registerCommandAnalyzer("let", new CommandAnalyzerLet(ctx));
        this.registerCommandAnalyzer("for", new CommandAnalyzerFor(ctx));
        this.registerCommandAnalyzer("next", new CommandAnalyzerNext(ctx));
        this.registerCommandAnalyzer(new CommandAnalyzerLet(ctx));
        this.registerCommandAnalyzer(new CommandAnalyzerCall(ctx));
    }

    @Override
    public void registerCommandAnalyzer(String keyword, CommandAnalyzer analyzer) {
        LOG.info("Registering command {}", keyword);
        if (keyword == null) {
            this.classList.add(analyzer);
        } else {
            this.classMap.put(keyword, analyzer);
        }
    }

    private void registerCommandAnalyzer(CommandAnalyzer analyzer) {
        this.registerCommandAnalyzer(null, analyzer);
    }

    @Override
    public Command create(String commandKeyword) throws AnalysisException {
        if (commandKeyword == null) {
            return this.create();
        }
        return this.createFromStartingSymbol(commandKeyword);
    }

    private Command create() throws AnalysisException {
        for (CommandAnalyzer commandAnalyzer : this.classList) {
            try {
                LOG.info("trying to analyze the line using {}", commandAnalyzer.getClass());
                Command command = (Command)commandAnalyzer.analyze();
                if (command != null) {
                    return command;
                }
            }
            catch (AnalysisException e) {
                LOG.info("Tried but not analyze the line using " + commandAnalyzer.getClass(), e);
            }
            this.ctx.lexicalAnalyzer.resetLine();
        }
        LOG.info("None of the analyzers could analyze the line", new Object[0]);
        throw new CommandFactoryException("The line could not be analyzed");
    }

    private Command createFromStartingSymbol(String commandKeyword) throws AnalysisException {
        String lowerCaseCommandKeyword = commandKeyword.toLowerCase();
        LOG.debug("Creating command starting with the keyword '{}'", lowerCaseCommandKeyword);
        if (!this.classMap.containsKey(lowerCaseCommandKeyword)) {
            throw new KeywordNotImplementedException(commandKeyword);
        }
        CommandAnalyzer commandAnalyzer = this.classMap.get(lowerCaseCommandKeyword);
        return (Command)commandAnalyzer.analyze();
    }
}

