/*
 * Decompiled with CFR 0.152.
 */
package cli;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.segment.analytics.Analytics;
import com.segment.analytics.Log;
import com.segment.analytics.messages.AliasMessage;
import com.segment.analytics.messages.GroupMessage;
import com.segment.analytics.messages.IdentifyMessage;
import com.segment.analytics.messages.MessageBuilder;
import com.segment.analytics.messages.PageMessage;
import com.segment.analytics.messages.ScreenMessage;
import com.segment.analytics.messages.TrackMessage;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.jvm.internal.TypeIntrinsics;
import org.docopt.Docopt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\u001a\u001f\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000f\"\u00020\t\u00a2\u0006\u0002\u0010\u0010\u001a\u0018\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\t\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"GSON", "Lcom/google/gson/Gson;", "ISO_8601_DATE_FORMAT", "Ljava/text/SimpleDateFormat;", "stdout", "Lcom/segment/analytics/Log;", "getStdout", "()Lcom/segment/analytics/Log;", "usage", "", "getUsage", "()Ljava/lang/String;", "main", "", "rawArgs", "", "([Ljava/lang/String;)V", "parseJson", "", "k", "analytics-cli"})
public final class MainKt {
    @NotNull
    private static final String usage = "\nAnalytics Java CLI\n\nUsage:\n  analytics track <event> [--properties=<properties>] [--context=<context>] [--writeKey=<writeKey>] [--userId=<userId>] [--anonymousId=<anonymousId>] [--integrations=<integrations>] [--timestamp=<timestamp>]\n  analytics screen <name> [--properties=<properties>] [--context=<context>] [--writeKey=<writeKey>] [--userId=<userId>] [--anonymousId=<anonymousId>] [--integrations=<integrations>] [--timestamp=<timestamp>]\n  analytics page <name> [--properties=<properties>] [--context=<context>] [--writeKey=<writeKey>] [--userId=<userId>] [--anonymousId=<anonymousId>] [--integrations=<integrations>] [--timestamp=<timestamp>]\n  analytics identify [--traits=<traits>] [--context=<context>] [--writeKey=<writeKey>] [--userId=<userId>] [--anonymousId=<anonymousId>] [--integrations=<integrations>] [--timestamp=<timestamp>]\n  analytics group --groupId=<groupId> [--traits=<traits>] [--properties=<properties>] [--context=<context>] [--writeKey=<writeKey>] [--userId=<userId>] [--anonymousId=<anonymousId>] [--integrations=<integrations>] [--timestamp=<timestamp>]\n  analytics alias --userId=<userId> --previousId=<previousId> [--traits=<traits>] [--properties=<properties>] [--context=<context>] [--writeKey=<writeKey>] [--anonymousId=<anonymousId>] [--integrations=<integrations>] [--timestamp=<timestamp>]\n\n  analytics -h | --help\n  analytics --version\n\nOptions:\n  -h --help     Show this screen.\n  --version     Show version.\n";
    private static final SimpleDateFormat ISO_8601_DATE_FORMAT;
    private static final Gson GSON;
    @NotNull
    private static final Log stdout;

    @NotNull
    public static final String getUsage() {
        return usage;
    }

    @NotNull
    public static final Log getStdout() {
        return stdout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(String ... rawArgs) {
        Object writeKey;
        Object integrations;
        Object timestamp;
        Object context;
        Object anonymousId;
        Object properties;
        MessageBuilder message;
        Intrinsics.checkParameterIsNotNull((Object)rawArgs, (String)"rawArgs");
        Map args = new Docopt(usage).parse(ArraysKt.toList((Object[])rawArgs));
        Object v = args.get("track");
        if (v == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        if (((Boolean)v).booleanValue()) {
            Object v2 = args.get("<event>");
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            TrackMessage.Builder builder = TrackMessage.builder((String)((String)v2));
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"TrackMessage.builder(args[\"<event>\"] as String)");
            message = (MessageBuilder)builder;
            properties = args.get("--properties");
            if (properties != null) {
                Object v3 = properties;
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                ((TrackMessage.Builder)message).properties(MainKt.parseJson((String)v3));
            }
        } else {
            Object v4 = args.get("page");
            if (v4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
            }
            if (((Boolean)v4).booleanValue()) {
                Object v5 = args.get("<name>");
                if (v5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                PageMessage.Builder builder = PageMessage.builder((String)((String)v5));
                Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"PageMessage.builder(args[\"<name>\"] as String)");
                message = (MessageBuilder)builder;
                properties = args.get("--properties");
                if (properties != null) {
                    Object v6 = properties;
                    if (v6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    ((PageMessage.Builder)message).properties(MainKt.parseJson((String)v6));
                }
            } else {
                Object v7 = args.get("screen");
                if (v7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                }
                if (((Boolean)v7).booleanValue()) {
                    Object v8 = args.get("<name>");
                    if (v8 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    ScreenMessage.Builder builder = ScreenMessage.builder((String)((String)v8));
                    Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"ScreenMessage.builder(args[\"<name>\"] as String)");
                    message = (MessageBuilder)builder;
                    properties = args.get("--properties");
                    if (properties != null) {
                        Object v9 = properties;
                        if (v9 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                        }
                        ((ScreenMessage.Builder)message).properties(MainKt.parseJson((String)v9));
                    }
                } else {
                    Object traits;
                    Object v10 = args.get("identify");
                    if (v10 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    if (((Boolean)v10).booleanValue()) {
                        IdentifyMessage.Builder builder = IdentifyMessage.builder();
                        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"IdentifyMessage.builder()");
                        message = (MessageBuilder)builder;
                        traits = args.get("--traits");
                        if (traits != null) {
                            Object v11 = traits;
                            if (v11 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                            }
                            ((IdentifyMessage.Builder)message).traits(MainKt.parseJson((String)v11));
                        }
                    } else {
                        Object v12 = args.get("alias");
                        if (v12 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        if (((Boolean)v12).booleanValue()) {
                            Object v13 = args.get("--previousId");
                            if (v13 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                            }
                            AliasMessage.Builder builder = AliasMessage.builder((String)((String)v13));
                            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"AliasMessage.builder(arg\u2026--previousId\"] as String)");
                            message = (MessageBuilder)builder;
                        } else {
                            Object v14 = args.get("group");
                            if (v14 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                            }
                            if (((Boolean)v14).booleanValue()) {
                                Object v15 = args.get("--groupId");
                                if (v15 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                                }
                                GroupMessage.Builder builder = GroupMessage.builder((String)((String)v15));
                                Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"GroupMessage.builder(args[\"--groupId\"] as String)");
                                message = (MessageBuilder)builder;
                                traits = args.get("--traits");
                                if (traits != null) {
                                    Object v16 = traits;
                                    if (v16 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                                    }
                                    ((GroupMessage.Builder)message).traits(MainKt.parseJson((String)v16));
                                }
                            } else {
                                throw (Throwable)((Object)new AssertionError((Object)"unknown command"));
                            }
                        }
                    }
                }
            }
        }
        Object userId = args.get("--userId");
        if (userId != null) {
            Object v17 = userId;
            if (v17 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            message.userId((String)v17);
        }
        if ((anonymousId = args.get("--anonymousId")) != null) {
            message.anonymousId(UUID.fromString((String)anonymousId));
        }
        if ((context = args.get("--context")) != null) {
            Object v18 = context;
            if (v18 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            message.context(MainKt.parseJson((String)v18));
        }
        if ((timestamp = args.get("--timestamp")) != null) {
            Object v19 = timestamp;
            if (v19 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            message.timestamp(ISO_8601_DATE_FORMAT.parse((String)v19));
        }
        if ((integrations = args.get("--integrations")) != null) {
            Map<String, ?> integrationsMap;
            Object v20 = integrations;
            if (v20 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            Map<String, ?> map = integrationsMap = MainKt.parseJson((String)v20);
            Iterator<Map.Entry<String, ?>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ?> entry;
                Map.Entry<String, ?> entry2 = entry = iterator.next();
                String key = entry2.getKey();
                Map.Entry<String, ?> entry3 = entry;
                Object value = entry3.getValue();
                if (value instanceof Boolean) {
                    message.enableIntegration(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Map) {
                    Object obj = value;
                    if (obj == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, in kotlin.Any>");
                    }
                    message.integrationOptions(key, TypeIntrinsics.asMutableMap(obj));
                    continue;
                }
                throw (Throwable)((Object)new AssertionError((Object)("Unknown type integrations map: " + key + ", " + value)));
            }
        }
        if ((writeKey = args.get("--writeKey")) == null) {
            writeKey = System.getenv("SEGMENT_WRITE_KEY");
        }
        Object v21 = writeKey;
        if (v21 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        Analytics analytics = Analytics.builder((String)((String)v21)).log(stdout).flushQueueSize(1).build();
        try {
            analytics.enqueue(message);
            Thread.sleep(2000L);
        }
        finally {
            analytics.shutdown();
        }
    }

    @NotNull
    public static final Map<String, ?> parseJson(@NotNull String k) {
        Intrinsics.checkParameterIsNotNull((Object)k, (String)"k");
        Type collectionType2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
        Map map = (Map)GSON.fromJson(k, collectionType2);
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"GSON.fromJson(k, collectionType)");
        return map;
    }

    static {
        usage = usage;
        ISO_8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        GSON = new Gson();
        stdout = new Log(){

            public void print(@NotNull Log.Level level, @NotNull String format, Object ... args) {
                Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
                Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
                Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                Object object = StringCompanionObject.INSTANCE;
                Object[] objectArray = Arrays.copyOf(args, args.length);
                String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
                object = string;
                System.out.println(object);
            }

            public void print(@NotNull Log.Level level, @NotNull Throwable error, @NotNull String format, Object ... args) {
                Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
                Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                Object object = StringCompanionObject.INSTANCE;
                Object[] objectArray = Arrays.copyOf(args, args.length);
                String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
                object = string;
                System.out.println(object);
                System.out.println(error);
            }
        };
    }
}

