/*
 * Decompiled with CFR 0.152.
 */
package cli;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.segment.analytics.Analytics;
import com.segment.analytics.Callback;
import com.segment.analytics.messages.AliasMessage;
import com.segment.analytics.messages.GroupMessage;
import com.segment.analytics.messages.IdentifyMessage;
import com.segment.analytics.messages.Message;
import com.segment.analytics.messages.MessageBuilder;
import com.segment.analytics.messages.PageMessage;
import com.segment.analytics.messages.ScreenMessage;
import com.segment.analytics.messages.TrackMessage;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Phaser;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.docopt.Docopt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\u001a\u0019\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\n\u001a\u0018\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\u0003\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"GSON", "Lcom/google/gson/Gson;", "usage", "", "getUsage", "()Ljava/lang/String;", "main", "", "rawArgs", "", "([Ljava/lang/String;)V", "parseJson", "", "k", "analytics-cli"})
public final class MainKt {
    @NotNull
    private static final String usage = "\nAnalytics Java CLI\n\nUsage:\n  analytics --writeKey=<writeKey> --type=<type> --userId=<userId> [--event=<event>] [--properties=<properties>] [--name=<name>] [--traits=<traits>] [--groupId=<groupId>] [--previousId=<previousId>] [--anonymousId=<anonymousId>] [--integrations=<integrations>] [--context=<context>]\n\n\n  analytics -h | --help\n  analytics --version\n\nOptions:\n  -h --help     Show this screen.\n  --version     Show version.\n";
    private static final Gson GSON = new Gson();

    @NotNull
    public static final String getUsage() {
        return usage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(@NotNull String[] rawArgs) {
        Object context;
        Iterator<Map.Entry<String, ?>> name;
        Object object;
        Object integrations;
        Object anonymousId;
        Object userId;
        Object traits;
        Object properties;
        Object eventType;
        Intrinsics.checkNotNullParameter(rawArgs, "rawArgs");
        Map<String, Object> args2 = new Docopt(usage).parse(ArraysKt.toList(rawArgs));
        MessageBuilder messageBuilder = null;
        Object object2 = eventType = args2.get("--type");
        if (Intrinsics.areEqual(object2, "track")) {
            Object object3 = args2.get("--event");
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            TrackMessage.Builder builder = TrackMessage.builder((String)object3);
            Intrinsics.checkNotNullExpressionValue(builder, "TrackMessage.builder(args[\"--event\"] as String)");
            messageBuilder = builder;
            properties = args2.get("--properties");
            if (properties != null) {
                ((TrackMessage.Builder)messageBuilder).properties(MainKt.parseJson((String)properties));
            }
        } else if (Intrinsics.areEqual(object2, "page")) {
            Object object4 = args2.get("--name");
            if (object4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            PageMessage.Builder builder = PageMessage.builder((String)object4);
            Intrinsics.checkNotNullExpressionValue(builder, "PageMessage.builder(args[\"--name\"] as String)");
            messageBuilder = builder;
            properties = args2.get("--properties");
            if (properties != null) {
                ((PageMessage.Builder)messageBuilder).properties(MainKt.parseJson((String)properties));
            }
        } else if (Intrinsics.areEqual(object2, "screen")) {
            Object object5 = args2.get("--name");
            if (object5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            ScreenMessage.Builder builder = ScreenMessage.builder((String)object5);
            Intrinsics.checkNotNullExpressionValue(builder, "ScreenMessage.builder(args[\"--name\"] as String)");
            messageBuilder = builder;
            properties = args2.get("--properties");
            if (properties != null) {
                ((ScreenMessage.Builder)messageBuilder).properties(MainKt.parseJson((String)properties));
            }
        } else if (Intrinsics.areEqual(object2, "identify")) {
            IdentifyMessage.Builder builder = IdentifyMessage.builder();
            Intrinsics.checkNotNullExpressionValue(builder, "IdentifyMessage.builder()");
            messageBuilder = builder;
            traits = args2.get("--traits");
            if (traits != null) {
                ((IdentifyMessage.Builder)messageBuilder).traits(MainKt.parseJson((String)traits));
            }
        } else if (Intrinsics.areEqual(object2, "alias")) {
            Object object6 = args2.get("--previousId");
            if (object6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            AliasMessage.Builder builder = AliasMessage.builder((String)object6);
            Intrinsics.checkNotNullExpressionValue(builder, "AliasMessage.builder(arg\u2026--previousId\"] as String)");
            messageBuilder = builder;
        } else if (Intrinsics.areEqual(object2, "group")) {
            Object object7 = args2.get("--groupId");
            if (object7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            GroupMessage.Builder builder = GroupMessage.builder((String)object7);
            Intrinsics.checkNotNullExpressionValue(builder, "GroupMessage.builder(args[\"--groupId\"] as String)");
            messageBuilder = builder;
            traits = args2.get("--traits");
            if (traits != null) {
                ((GroupMessage.Builder)messageBuilder).traits(MainKt.parseJson((String)traits));
            }
        } else {
            throw (Throwable)((Object)new AssertionError((Object)"unknown command"));
        }
        if ((userId = args2.get("--userId")) != null) {
            messageBuilder.userId((String)userId);
        }
        if ((anonymousId = args2.get("--anonymousId")) != null) {
            messageBuilder.anonymousId((String)anonymousId);
        }
        if ((integrations = args2.get("--integrations")) != null) {
            Map<String, ?> integrationsMap = MainKt.parseJson((String)integrations);
            Object object8 = integrationsMap;
            boolean bl = false;
            object = object8.entrySet().iterator();
            while (object.hasNext()) {
                Object options;
                Map.Entry<String, ?> entry;
                Map.Entry<String, ?> entry2 = entry = object.next();
                boolean bl2 = false;
                object8 = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                Object obj = options = entry2.getValue();
                if (obj == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
                }
                messageBuilder.integrationOptions((String)((Object)name), (Map)obj);
            }
        }
        if ((context = args2.get("--context")) != null) {
            Map<String, ?> contextMap = MainKt.parseJson((String)context);
            Object options = contextMap;
            boolean bl = false;
            name = options.entrySet().iterator();
            while (name.hasNext()) {
                Object object9 = object = name.next();
                boolean bl3 = false;
                options = (String)object9.getKey();
                object9 = object;
                bl3 = false;
                Object options2 = object9.getValue();
                messageBuilder.context(contextMap);
            }
        }
        Object object10 = args2.get("--writeKey");
        if (object10 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String writeKey = (String)object10;
        Phaser phaser = new Phaser(1);
        Analytics analytics2 = Analytics.builder(writeKey).flushQueueSize(1).callback(new Callback(phaser){
            final /* synthetic */ Phaser $phaser;

            public void success(@Nullable Message message) {
                this.$phaser.arrive();
            }

            public void failure(@Nullable Message message, @Nullable Throwable throwable) {
                Throwable throwable2 = throwable;
                Intrinsics.checkNotNull(throwable2);
                throw throwable2;
            }
            {
                this.$phaser = $captured_local_variable$0;
            }
        }).build();
        try {
            phaser.register();
            analytics2.enqueue(messageBuilder);
            phaser.arriveAndAwaitAdvance();
        }
        finally {
            analytics2.shutdown();
        }
    }

    @NotNull
    public static final Map<String, ?> parseJson(@NotNull String k) {
        Intrinsics.checkNotNullParameter(k, "k");
        Type collectionType2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
        Object t = GSON.fromJson(k, collectionType2);
        Intrinsics.checkNotNullExpressionValue(t, "GSON.fromJson(k, collectionType)");
        return (Map)t;
    }
}

