/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class AnalyticsRequestInterceptor
implements Interceptor {
    private static final String USER_AGENT_HEADER = "User-Agent";
    @Nonnull
    private final String userAgent;

    AnalyticsRequestInterceptor(@Nonnull String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request newRequest = request.newBuilder().addHeader(USER_AGENT_HEADER, this.userAgent).build();
        return chain.proceed(newRequest);
    }
}

