/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics.messages;

import com.google.auto.value.AutoValue;
import com.segment.analytics.gson.AutoGson;
import com.segment.analytics.messages.AutoValue_IdentifyMessage;
import com.segment.analytics.messages.ImmutableMap;
import com.segment.analytics.messages.Message;
import com.segment.analytics.messages.MessageBuilder;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Map;

@AutoGson
@AutoValue
public abstract class IdentifyMessage
implements Message {
    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public abstract Map<String, ?> traits();

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends MessageBuilder<IdentifyMessage, Builder> {
        private Map<String, ?> traits;

        private Builder(IdentifyMessage identify) {
            super(identify);
            this.traits = identify.traits();
        }

        private Builder() {
            super(Message.Type.identify);
        }

        public Builder traits(Map<String, ?> traits) {
            if (traits == null) {
                throw new NullPointerException("Null traits");
            }
            this.traits = ImmutableMap.copyOf(traits);
            return this;
        }

        @Override
        protected IdentifyMessage realBuild(Message.Type type, String messageId, Date sentAt, Date timestamp, Map<String, ?> context, String anonymousId, String userId, Map<String, Object> integrations) {
            if (userId == null && this.traits == null) {
                throw new IllegalStateException("Either userId or traits must be provided.");
            }
            return new AutoValue_IdentifyMessage(type, messageId, sentAt, timestamp, context, anonymousId, userId, integrations, this.traits);
        }

        @Override
        Builder self() {
            return this;
        }
    }
}

