/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics.messages;

import com.google.auto.value.AutoValue;
import com.segment.analytics.gson.AutoGson;
import com.segment.analytics.messages.AutoValue_ScreenMessage;
import com.segment.analytics.messages.ImmutableMap;
import com.segment.analytics.messages.Message;
import com.segment.analytics.messages.MessageBuilder;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Map;

@AutoGson
@AutoValue
public abstract class ScreenMessage
implements Message {
    public static Builder builder(String name) {
        return new Builder(name);
    }

    public abstract String name();

    @Nullable
    public abstract Map<String, ?> properties();

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends MessageBuilder<ScreenMessage, Builder> {
        private String name;
        private Map<String, ?> properties;

        private Builder(ScreenMessage screen) {
            super(screen);
            this.name = screen.name();
            this.properties = screen.properties();
        }

        private Builder(String name) {
            super(Message.Type.screen);
            if (Builder.isNullOrEmpty(name)) {
                throw new IllegalArgumentException("screen name cannot be null or empty.");
            }
            this.name = name;
        }

        public Builder properties(Map<String, ?> properties) {
            if (properties == null) {
                throw new NullPointerException("Null properties");
            }
            this.properties = ImmutableMap.copyOf(properties);
            return this;
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        protected ScreenMessage realBuild(Message.Type type, String messageId, Date sentAt, Date timestamp, Map<String, ?> context, String anonymousId, String userId, Map<String, Object> integrations) {
            return new AutoValue_ScreenMessage(type, messageId, sentAt, timestamp, context, anonymousId, userId, integrations, this.name, this.properties);
        }
    }
}

