/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.browserfactory;

import com.seleniumtests.core.TestLogging;
import com.seleniumtests.driver.DriverConfig;
import com.seleniumtests.driver.WebUIDriver;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public abstract class AbstractWebDriverFactory {
    protected DriverConfig webDriverConfig;
    protected WebDriver driver;

    public AbstractWebDriverFactory(DriverConfig cfg) {
        this.webDriverConfig = cfg;
    }

    public void cleanUp() {
        block4: {
            try {
                if (this.driver == null) break block4;
                try {
                    TestLogging.log("quiting webdriver" + Thread.currentThread().getId());
                    this.driver.quit();
                }
                catch (WebDriverException ex) {
                    TestLogging.log("Exception encountered when quiting driver: " + WebUIDriver.getWebUIDriver().getConfig().getBrowser().name() + ":" + ex.getMessage());
                }
                this.driver = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public WebDriver createWebDriver() throws Exception {
        return null;
    }

    public WebDriver getWebDriver() {
        return this.driver;
    }

    public DriverConfig getWebDriverConfig() {
        return this.webDriverConfig;
    }

    public void setImplicitWaitTimeout(double timeout) {
        if (timeout < 1.0) {
            this.driver.manage().timeouts().implicitlyWait((long)(timeout * 1000.0), TimeUnit.MILLISECONDS);
        } else {
            try {
                this.driver.manage().timeouts().implicitlyWait((long)new Double(timeout).intValue(), TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setWebDriver(WebDriver driver) {
        this.driver = driver;
    }

    public void setWebDriverConfig(DriverConfig cfg) {
        this.webDriverConfig = cfg;
    }
}

