/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.browserfactory;

import com.seleniumtests.browserfactory.ICapabilitiesFactory;
import com.seleniumtests.driver.DriverConfig;
import com.seleniumtests.driver.DriverMode;
import com.seleniumtests.helper.FileUtility;
import com.seleniumtests.helper.OSUtility;
import com.seleniumtests.resources.WebDriverExternalResources;
import java.io.File;
import java.io.IOException;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromeCapabilitiesFactory
implements ICapabilitiesFactory {
    @Override
    public DesiredCapabilities createCapabilities(DriverConfig webDriverConfig) {
        DesiredCapabilities capability;
        block13: {
            capability = null;
            capability = DesiredCapabilities.chrome();
            capability.setBrowserName(DesiredCapabilities.chrome().getBrowserName());
            ChromeOptions options = new ChromeOptions();
            if (webDriverConfig.getUserAgentOverride() != null) {
                options.addArguments(new String[]{"--user-agent=" + webDriverConfig.getUserAgentOverride()});
            }
            capability.setCapability("goog:chromeOptions", (Object)options);
            if (webDriverConfig.isEnableJavascript()) {
                capability.setJavascriptEnabled(true);
            } else {
                capability.setJavascriptEnabled(false);
            }
            capability.setCapability("takesScreenshot", true);
            capability.setCapability("acceptSslCerts", true);
            if (webDriverConfig.getBrowserVersion() != null) {
                capability.setVersion(webDriverConfig.getBrowserVersion());
            }
            if (webDriverConfig.getWebPlatform() != null) {
                capability.setPlatform(webDriverConfig.getWebPlatform());
            }
            if (webDriverConfig.getProxyHost() != null) {
                Proxy proxy = webDriverConfig.getProxy();
                capability.setCapability("proxy", (Object)proxy);
            }
            if (webDriverConfig.getChromeBinPath() != null) {
                capability.setCapability("chrome.binary", webDriverConfig.getChromeBinPath());
            }
            if (webDriverConfig.getMode() == DriverMode.LOCAL) {
                String chromeDriverPath = webDriverConfig.getChromeDriverPath();
                if (chromeDriverPath == null) {
                    try {
                        if (System.getenv("webdriver.chrome.driver") != null) {
                            System.out.println("get Chrome driver from property:" + System.getenv("webdriver.chrome.driver"));
                            System.setProperty("webdriver.chrome.driver", System.getenv("webdriver.chrome.driver"));
                            break block13;
                        }
                        this.handleExtractResources();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                } else {
                    System.setProperty("webdriver.chrome.driver", chromeDriverPath);
                }
            }
        }
        return capability;
    }

    public void handleExtractResources() throws IOException {
        String dir = this.getClass().getResource("/").getPath();
        if (!new File(dir = FileUtility.decodePath(dir)).exists()) {
            System.out.println("extracting chrome resources in " + dir);
            FileUtility.extractJar(dir, WebDriverExternalResources.class);
        }
        if (!new File(dir + OSUtility.getSlash() + "chromedriver.exe").exists()) {
            FileUtility.extractJar(dir, WebDriverExternalResources.class);
        }
        if (OSUtility.isWindows()) {
            System.setProperty("webdriver.chrome.driver", dir + "\\chromedriver.exe");
        } else if (OSUtility.isMac()) {
            System.setProperty("webdriver.chrome.driver", dir + "/mac/chromedriver");
        } else {
            System.setProperty("webdriver.chrome.driver", dir + "/chromedriver");
            new File(dir + "/chromedriver").setExecutable(true);
        }
    }
}

