/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.browserfactory;

import com.seleniumtests.browserfactory.AbstractWebDriverFactory;
import com.seleniumtests.browserfactory.IECapabilitiesFactory;
import com.seleniumtests.browserfactory.IWebDriverFactory;
import com.seleniumtests.driver.DriverConfig;
import com.seleniumtests.helper.OSUtility;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.ie.InternetExplorerDriver;

public class IEDriverFactory
extends AbstractWebDriverFactory
implements IWebDriverFactory {
    public IEDriverFactory(DriverConfig webDriverConfig1) {
        super(webDriverConfig1);
    }

    @Override
    public void cleanUp() {
        block4: {
            try {
                if (this.driver == null) break block4;
                try {
                    this.driver.quit();
                }
                catch (WebDriverException ex) {
                    ex.printStackTrace();
                }
                this.driver = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public WebDriver createWebDriver() throws IOException {
        if (!OSUtility.isWindows()) {
            throw new RuntimeException("With gods grace IE browser is only supported on windows, Imagine a situation when you have to fix IE bugs on Unix and Mac as well");
        }
        DriverConfig cfg = this.getWebDriverConfig();
        this.driver = new InternetExplorerDriver((Capabilities)new IECapabilitiesFactory().createCapabilities(cfg));
        this.setImplicitWaitTimeout(cfg.getImplicitWaitTimeout());
        if (cfg.getPageLoadTimeout() >= 0) {
            this.driver.manage().timeouts().pageLoadTimeout((long)cfg.getPageLoadTimeout(), TimeUnit.SECONDS);
        }
        this.setWebDriver(this.driver);
        return this.driver;
    }

    private void killProcess() {
        if (OSUtility.isWindows()) {
            try {
                Runtime.getRuntime().exec("taskkill /F /IM IEDriverServer.exe");
                Runtime.getRuntime().exec("taskkill /F /IM Iexplore.exe");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

