/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.core;

import com.seleniumtests.core.SeleniumTestsContextManager;
import com.seleniumtests.core.TestLogging;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.testng.Assert;
import org.testng.Reporter;

public class CustomAssertion {
    private static void addVerificationFailure(Throwable e) {
        SeleniumTestsContextManager.getThreadContext().addVerificationFailures(Reporter.getCurrentTestResult(), e);
        TestLogging.log("!!!FAILURE ALERT!!! - Assertion Failure: " + e.getMessage(), true, true);
    }

    public static void assertEquals(boolean actual, boolean expected, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertEquals(actual, expected, message);
        } else {
            Assert.assertEquals((boolean)actual, (boolean)expected, (String)message);
        }
    }

    public static void assertEquals(byte actual, byte expected, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertEquals(actual, expected, message);
        } else {
            Assert.assertEquals((byte)actual, (byte)expected, (String)message);
        }
    }

    public static void assertEquals(byte[] actual, byte[] expected, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertEquals(actual, expected, message);
        } else {
            Assert.assertEquals((byte[])actual, (byte[])expected, (String)message);
        }
    }

    public static void assertEquals(char actual, char expected, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertEquals(actual, expected, message);
        } else {
            Assert.assertEquals((char)actual, (char)expected, (String)message);
        }
    }

    public static void assertEquals(Collection actual, Collection expected, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertEquals(actual, expected, message);
        } else {
            Assert.assertEquals((Collection)actual, (Collection)expected, (String)message);
        }
    }

    public static void assertEquals(double actual, double expected, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertEquals(actual, expected, message);
        } else {
            Assert.assertEquals((double)actual, (double)expected, (String)message);
        }
    }

    public static void assertEquals(float actual, float expected, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertEquals(actual, expected, message);
        } else {
            Assert.assertEquals((float)actual, (float)expected, (String)message);
        }
    }

    public static void assertEquals(int actual, int expected, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertEquals(actual, expected, message);
        } else {
            Assert.assertEquals((int)actual, (int)expected, (String)message);
        }
    }

    public static void assertEquals(long actual, long expected, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertEquals(actual, expected, message);
        } else {
            Assert.assertEquals((long)actual, (long)expected, (String)message);
        }
    }

    public static void assertEquals(Object actual, Object expected, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertEquals(actual, expected, message);
        } else {
            Assert.assertEquals((Object)actual, (Object)expected, (String)message);
        }
    }

    public static void assertEquals(Object[] actual, Object[] expected, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertEquals(actual, expected, message);
        } else {
            Assert.assertEquals((Object[])actual, (Object[])expected, (String)message);
        }
    }

    public static void assertEquals(short actual, short expected, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertEquals(actual, expected, message);
        } else {
            Assert.assertEquals((short)actual, (short)expected, (String)message);
        }
    }

    public static void assertEquals(String actual, String expected, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertEquals(actual, expected, message);
        } else {
            Assert.assertEquals((String)actual, (String)expected, (String)message);
        }
    }

    public static void assertFalse(boolean condition, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertFalse(condition, message);
        } else {
            Assert.assertFalse((boolean)condition, (String)message);
        }
    }

    public static void assertNotNull(Object object, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertNotNull(object, message);
        } else {
            Assert.assertNotNull((Object)object, (String)message);
        }
    }

    public static void assertNotSame(Object actual, Object expected, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertNotSame(actual, expected, message);
        } else {
            Assert.assertNotSame((Object)actual, (Object)expected, (String)message);
        }
    }

    public static void assertNull(Object object, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertNull(object, message);
        } else {
            Assert.assertNull((Object)object, (String)message);
        }
    }

    public static void assertSame(Object actual, Object expected, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertSame(actual, expected, message);
        } else {
            Assert.assertSame((Object)actual, (Object)expected, (String)message);
        }
    }

    public static void assertTrue(boolean condition, String message) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertTrue(condition, message);
        } else {
            Assert.assertTrue((boolean)condition, (String)message);
        }
    }

    public static void assertThat(String reason, boolean assertion) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertThat(reason, assertion);
        } else {
            MatcherAssert.assertThat((String)reason, (boolean)assertion);
        }
    }

    public static <T> void assertThat(String reason, T actual, Matcher<? super T> matcher) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertThat(reason, actual, matcher);
        } else {
            MatcherAssert.assertThat((String)reason, actual, matcher);
        }
    }

    public static <T> void assertThat(T actual, Matcher<? super T> matcher) {
        if (SeleniumTestsContextManager.getThreadContext().isSoftAssertEnabled()) {
            CustomAssertion.softAssertThat(actual, matcher);
        } else {
            MatcherAssert.assertThat(actual, matcher);
        }
    }

    public static void fail(String message) {
        Assert.fail((String)message);
    }

    public static List<Throwable> getVerificationFailures() {
        return SeleniumTestsContextManager.getThreadContext().getVerificationFailures(Reporter.getCurrentTestResult());
    }

    public static void softAssertEquals(boolean actual, boolean expected, String message) {
        try {
            Assert.assertEquals((boolean)actual, (boolean)expected, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertEquals(byte actual, byte expected, String message) {
        try {
            Assert.assertEquals((byte)actual, (byte)expected, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertEquals(byte[] actual, byte[] expected, String message) {
        try {
            Assert.assertEquals((byte[])actual, (byte[])expected, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertEquals(char actual, char expected, String message) {
        try {
            Assert.assertEquals((char)actual, (char)expected, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertEquals(Collection actual, Collection expected, String message) {
        try {
            Assert.assertEquals((Collection)actual, (Collection)expected, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertEquals(double actual, double expected, String message) {
        try {
            Assert.assertEquals((double)actual, (double)expected, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertEquals(float actual, float expected, String message) {
        try {
            Assert.assertEquals((float)actual, (float)expected, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertEquals(int actual, int expected, String message) {
        try {
            Assert.assertEquals((int)actual, (int)expected, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertEquals(long actual, long expected, String message) {
        try {
            Assert.assertEquals((long)actual, (long)expected, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertEquals(Object actual, Object expected, String message) {
        try {
            Assert.assertEquals((Object)actual, (Object)expected, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertEquals(Object[] actual, Object[] expected, String message) {
        try {
            Assert.assertEquals((Object[])actual, (Object[])expected, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertEquals(short actual, short expected, String message) {
        try {
            Assert.assertEquals((short)actual, (short)expected, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertEquals(String actual, String expected, String message) {
        try {
            Assert.assertEquals((String)actual, (String)expected, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertFalse(boolean condition, String message) {
        try {
            Assert.assertFalse((boolean)condition, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertNotNull(Object object, String message) {
        try {
            Assert.assertNotNull((Object)object, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertNotSame(Object actual, Object expected, String message) {
        try {
            Assert.assertNotSame((Object)actual, (Object)expected, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertNull(Object object, String message) {
        try {
            Assert.assertNull((Object)object, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertSame(Object actual, Object expected, String message) {
        try {
            Assert.assertSame((Object)actual, (Object)expected, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertTrue(boolean condition, String message) {
        try {
            Assert.assertTrue((boolean)condition, (String)message);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static void softAssertThat(String reason, boolean assertion) {
        try {
            MatcherAssert.assertThat((String)reason, (boolean)assertion);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static <T> void softAssertThat(String reason, T actual, Matcher<? super T> matcher) {
        try {
            MatcherAssert.assertThat((String)reason, actual, matcher);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }

    public static <T> void softAssertThat(T actual, Matcher<? super T> matcher) {
        try {
            MatcherAssert.assertThat(actual, matcher);
        }
        catch (Throwable e) {
            CustomAssertion.addVerificationFailure(e);
        }
    }
}

