/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.core;

import com.seleniumtests.core.SeleniumTestsContextManager;
import com.seleniumtests.core.TestLogging;
import com.seleniumtests.reporter.PluginsHelper;
import com.seleniumtests.webelements.IPage;
import org.apache.log4j.Logger;

public abstract class SeleniumTestsPageListener {
    protected static final Logger logger = TestLogging.getLogger(SeleniumTestsPageListener.class);
    private String title;
    private boolean testResultEffected;

    public static void informPageLoad(IPage page) {
        PluginsHelper.getInstance().invokePageListeners(SeleniumTestsContextManager.getThreadContext().getTestMethodSignature(), page, true);
    }

    public static void informPageUnload(IPage page) {
        PluginsHelper.getInstance().invokePageListeners(SeleniumTestsContextManager.getThreadContext().getTestMethodSignature(), page, false);
    }

    public SeleniumTestsPageListener(String title, boolean testResultEffected) {
        this.title = title;
        this.testResultEffected = testResultEffected;
    }

    public SeleniumTestsPageListener() {
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isTestResultEffected() {
        return this.testResultEffected;
    }

    public abstract void onPageLoad(IPage var1);

    public abstract void onPageUnload(IPage var1);
}

