/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.driver;

import com.seleniumtests.core.SeleniumTestsContextManager;
import com.seleniumtests.core.TestLogging;
import com.seleniumtests.customexception.WebSessionEndedException;
import com.seleniumtests.driver.BrowserType;
import com.seleniumtests.driver.ScreenShot;
import com.seleniumtests.driver.WebUIDriver;
import com.seleniumtests.helper.FileUtility;
import com.seleniumtests.helper.HashCodeGenerator;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;

public class ScreenshotUtil {
    private static final Logger logger = Logger.getLogger(ScreenshotUtil.class);
    private String suiteName = ScreenshotUtil.getSuiteName();
    private String outputDirectory = ScreenshotUtil.getOutputDirectory();
    private WebDriver driver;
    private String filename;

    public static String captureEntirePageScreenshotToString(WebDriver driver, String arg0) {
        if (driver == null) {
            return "";
        }
        try {
            if (WebUIDriver.getWebUIDriver().getBrowser().equalsIgnoreCase(BrowserType.HtmlUnit.getBrowserType())) {
                return null;
            }
            if (WebUIDriver.getWebUIDriver().getBrowser().equalsIgnoreCase(BrowserType.Android.getBrowserType())) {
                return null;
            }
            TakesScreenshot screenShot = (TakesScreenshot)driver;
            return (String)screenShot.getScreenshotAs(OutputType.BASE64);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public ScreenshotUtil() {
        this.driver = WebUIDriver.getWebDriver();
    }

    public ScreenshotUtil(WebDriver driver) {
        this.driver = driver;
    }

    private static String getSuiteName() {
        String suiteName = null;
        suiteName = SeleniumTestsContextManager.getGlobalContext().getTestNGContext().getSuite().getName();
        return suiteName;
    }

    private static String getOutputDirectory() {
        String outputDirectory = null;
        outputDirectory = SeleniumTestsContextManager.getGlobalContext().getTestNGContext().getOutputDirectory();
        return outputDirectory;
    }

    private void handleSource(String htmlSource, ScreenShot screenShot) {
        if (htmlSource == null) {
            htmlSource = this.driver.getPageSource();
        }
        if (htmlSource != null) {
            try {
                FileUtility.writeToFile(this.outputDirectory + "/htmls/" + this.filename + ".html", htmlSource);
                screenShot.setHtmlSourcePath(this.suiteName + "/htmls/" + this.filename + ".html");
            }
            catch (IOException e) {
                logger.warn((Object)"Ex", (Throwable)e);
            }
        }
    }

    private void handleImage(ScreenShot screenShot) {
        try {
            String screenshotString = ScreenshotUtil.captureEntirePageScreenshotToString(WebUIDriver.getWebDriver(), "");
            if (screenshotString != null && !screenshotString.equalsIgnoreCase("")) {
                byte[] byteArray = screenshotString.getBytes();
                FileUtility.writeImage(this.outputDirectory + "/screenshots/" + this.filename + ".png", byteArray);
                screenShot.setImagePath(this.suiteName + "/screenshots/" + this.filename + ".png");
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"Ex", e);
            e.printStackTrace();
        }
    }

    private void handleTitle(String title, ScreenShot screenShot) {
        if (title == null) {
            title = this.driver.getTitle();
        }
        if (title == null) {
            title = "";
        }
        screenShot.setTitle(title);
    }

    public ScreenShot captureWebPageSnapshot() {
        ScreenShot screenShot = new ScreenShot();
        if (SeleniumTestsContextManager.getThreadContext() == null || this.outputDirectory == null) {
            return screenShot;
        }
        screenShot.setSuiteName(this.suiteName);
        try {
            String filename;
            String url = null;
            try {
                url = this.driver.getCurrentUrl();
            }
            catch (UnhandledAlertException ex) {
                ex.printStackTrace();
                url = this.driver.getCurrentUrl();
            }
            String title = this.driver.getTitle();
            String pageSource = this.driver.getPageSource();
            this.filename = filename = HashCodeGenerator.getRandomHashCode("web");
            screenShot.setLocation(url);
            this.handleTitle(title, screenShot);
            this.handleSource(pageSource, screenShot);
            if (SeleniumTestsContextManager.getThreadContext().getCaptureSnapshot()) {
                this.handleImage(screenShot);
            }
        }
        catch (WebSessionEndedException e) {
            throw e;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (SeleniumTestsContextManager.getThreadContext().getCaptureSnapshot()) {
            SeleniumTestsContextManager.getThreadContext().addScreenShot(screenShot);
        }
        return screenShot;
    }

    public void capturePageSnapshotOnException() {
        Boolean capture = SeleniumTestsContextManager.getThreadContext().getCaptureSnapshot();
        SeleniumTestsContextManager.getThreadContext().setAttribute("captureSnapshot", "true");
        this.captureWebPageSnapshot();
        SeleniumTestsContextManager.getThreadContext().setAttribute("captureSnapshot", Boolean.toString(capture));
        if (SeleniumTestsContextManager.getThreadContext().getScreenshots().size() > 0) {
            SeleniumTestsContextManager.getThreadContext().getScreenshots().getLast().setException(true);
        }
    }

    public static void captureSnapshot(String messagePrefix) {
        if (SeleniumTestsContextManager.getThreadContext() != null && SeleniumTestsContextManager.getThreadContext().getCaptureSnapshot() && ScreenshotUtil.getOutputDirectory() != null) {
            String filename = HashCodeGenerator.getRandomHashCode("HtmlElement");
            StringBuffer sbMessage = new StringBuffer();
            try {
                String img = ScreenshotUtil.captureEntirePageScreenshotToString(WebUIDriver.getWebDriver(), "");
                if (img == null) {
                    return;
                }
                byte[] byteArray = img.getBytes();
                if (byteArray != null && byteArray.length > 0) {
                    String imgFile = "/screenshots/" + filename + ".png";
                    FileUtility.writeImage(ScreenshotUtil.getOutputDirectory() + imgFile, byteArray);
                    ScreenShot screenShot = new ScreenShot();
                    String imagePath = ScreenshotUtil.getSuiteName() + imgFile;
                    screenShot.setImagePath(imagePath);
                    SeleniumTestsContextManager.getThreadContext().addScreenShot(screenShot);
                    sbMessage.append(messagePrefix + ": <a href='" + imagePath + "' class='lightbox'>Application Snapshot</a>");
                    TestLogging.logWebOutput(null, sbMessage.toString(), false);
                    sbMessage = null;
                }
            }
            catch (WebSessionEndedException ex) {
                throw ex;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

