/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.helper;

import com.seleniumtests.helper.OSUtility;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.channels.FileLock;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class FileUtility {
    static Logger logger = Logger.getLogger(FileUtility.class);
    static final int BUFFER = 2048;
    private static Map<Integer, FileLock> fileLockMap = new HashMap<Integer, FileLock>();

    public static void extractJar(String storeLocation, Class<?> clz) throws IOException {
        File firefoxProfile = new File(storeLocation);
        String location = clz.getProtectionDomain().getCodeSource().getLocation().getFile();
        JarFile jar = new JarFile(location);
        System.out.println("Extracting jar file::: " + location);
        firefoxProfile.mkdir();
        Enumeration<JarEntry> jarFiles = jar.entries();
        while (jarFiles.hasMoreElements()) {
            int currentByte;
            ZipEntry entry = jarFiles.nextElement();
            String currentEntry = entry.getName();
            File destinationFile = new File(storeLocation, currentEntry);
            File destinationParent = destinationFile.getParentFile();
            destinationParent.mkdirs();
            if (entry.isDirectory()) continue;
            BufferedInputStream is = new BufferedInputStream(jar.getInputStream(entry));
            byte[] data = new byte[2048];
            FileOutputStream fos = new FileOutputStream(destinationFile);
            BufferedOutputStream destination = new BufferedOutputStream(fos, 2048);
            while ((currentByte = is.read(data, 0, 2048)) != -1) {
                destination.write(data, 0, currentByte);
            }
            destination.flush();
            destination.close();
            is.close();
        }
        FileUtils.deleteDirectory((File)new File(storeLocation + "\\META-INF"));
        if (OSUtility.isWindows()) {
            new File(storeLocation + "\\" + clz.getCanonicalName().replaceAll("\\.", "\\\\") + ".class").delete();
        } else {
            new File(storeLocation + "/" + clz.getCanonicalName().replaceAll("\\.", "/") + ".class").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File srcPath, File dstPath) throws IOException {
        if (srcPath.isDirectory()) {
            String[] files;
            if (!dstPath.exists()) {
                dstPath.mkdir();
            }
            for (String file : files = srcPath.list()) {
                FileUtility.copyFile(new File(srcPath, file), new File(dstPath, file));
            }
        } else {
            if (!srcPath.exists()) {
                throw new IOException("Directory Not Found ::: " + srcPath);
            }
            InputStream in = null;
            OutputStream out = null;
            try {
                int len;
                if (!dstPath.getParentFile().exists()) {
                    dstPath.getParentFile().mkdirs();
                }
                in = new FileInputStream(srcPath);
                out = new FileOutputStream(dstPath);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void copyFile(String srcPath, String dstPath) throws IOException {
        FileUtility.copyFile(new File(srcPath), new File(dstPath));
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files;
            for (File file : files = path.listFiles()) {
                if (file.isDirectory()) {
                    FileUtility.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return path.delete();
    }

    public static boolean deleteDirectory(String dir) {
        return FileUtility.deleteDirectory(new File(dir));
    }

    public static String readFromFile(File path) throws IOException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(path);
            String string = FileUtility.readFromFile(fis);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromFile(InputStream path) throws IOException {
        InputStreamReader fr = null;
        BufferedReader br = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            fr = new InputStreamReader(path);
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                stringBuilder.append(line).append("\n");
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void writeImage(String path, byte[] byteArray) {
        if (byteArray.length == 0) {
            return;
        }
        System.gc();
        InputStream in = null;
        FileOutputStream fos = null;
        try {
            File parentDir = new File(path).getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            byte[] decodeBuffer = Base64.decodeBase64((byte[])byteArray);
            in = new ByteArrayInputStream(decodeBuffer);
            BufferedImage img = ImageIO.read(in);
            fos = new FileOutputStream(path);
            ImageIO.write((RenderedImage)img, "png", fos);
            img = null;
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String path, String content) throws IOException {
        System.gc();
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bw = null;
        try {
            File parentDir = new File(path).getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            fileOutputStream = new FileOutputStream(path);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
            bw = new BufferedWriter(outputStreamWriter);
            bw.write(content);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getLatestFile(String folder) {
        String file = null;
        File folderFile = new File(folder);
        if (folderFile.exists() && folderFile.isDirectory()) {
            File[] files = folderFile.listFiles();
            long date = 0L;
            for (int i = 0; i < files.length; ++i) {
                if (files[i].lastModified() <= date) continue;
                date = files[i].lastModified();
                file = files[i].getAbsolutePath();
            }
        }
        return file;
    }

    public static String decodePath(String path) throws UnsupportedEncodingException {
        return URLDecoder.decode(path, "UTF-8");
    }
}

