/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.util;

import com.seleniumtests.core.Filter;
import com.seleniumtests.core.SeleniumTestsContextManager;
import com.seleniumtests.util.CSVHelper;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SpreadSheetHelper {
    private static Logger logger = Logger.getLogger(SpreadSheetHelper.class);
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TYPE_MAP = new HashMap();

    private static Object _readFieldValueObject(Class<?> fieldClz, Type type, Map<String, Object> dataMap, String combinedFieldName) throws Exception {
        Object fieldValue = null;
        if (fieldClz.isArray()) {
            int size = SpreadSheetHelper.getArraySize(dataMap, combinedFieldName);
            if (size > 0) {
                fieldValue = Array.newInstance(fieldClz.getComponentType(), size);
                for (int j = 0; j < size; ++j) {
                    Array.set(fieldValue, j, SpreadSheetHelper.readFieldValue(fieldClz.getComponentType(), combinedFieldName + "." + j, dataMap));
                }
            }
        } else if (fieldClz.isAssignableFrom(List.class)) {
            ArrayList list = (ArrayList)ArrayList.class.newInstance();
            int size = SpreadSheetHelper.getArraySize(dataMap, combinedFieldName);
            if (size > 0) {
                fieldValue = list;
                Class<?> itemClz = SpreadSheetHelper.getListItemType(type);
                for (int j = 0; j < size; ++j) {
                    list.add(SpreadSheetHelper.readFieldValue(itemClz, combinedFieldName + "." + j, dataMap));
                }
            }
        } else if (fieldClz.isAssignableFrom(Set.class)) {
            Set list = (Set)LinkedHashSet.class.newInstance();
            int size = SpreadSheetHelper.getArraySize(dataMap, combinedFieldName);
            if (size > 0) {
                fieldValue = list;
                Class<?> itemClz = SpreadSheetHelper.getListItemType(type);
                for (int j = 0; j < size; ++j) {
                    list.add(SpreadSheetHelper.readFieldValue(itemClz, combinedFieldName + "." + j, dataMap));
                }
            }
        } else {
            fieldValue = SpreadSheetHelper.readFieldValue(fieldClz, combinedFieldName, dataMap);
        }
        return fieldValue;
    }

    protected static void formatDPTags(Map<String, Object> rowDataMap) {
        String dpTags;
        if (rowDataMap.get("TestEntity.TestTags") != null && (dpTags = rowDataMap.get("TestEntity.TestTags").toString()).trim().length() > 0) {
            String[] dpTagArray = dpTags.split(",");
            String tempDPTags = "";
            for (int idx = 0; dpTagArray.length > 0 && idx < dpTagArray.length; ++idx) {
                tempDPTags = tempDPTags.concat("[" + dpTagArray[idx].trim() + "]");
                if (idx == dpTagArray.length - 1) continue;
                tempDPTags = tempDPTags.concat(",");
            }
            rowDataMap.put("TestEntity.TestTags", tempDPTags);
        }
    }

    public static int getArraySize(Map<String, Object> map, String key) {
        int count = 0;
        boolean valueFound = false;
        key = key.toLowerCase();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key2 = entry.getKey();
            String value2 = (String)entry.getValue();
            if (value2 == null || value2.length() == 0 || !(key2 = key2.toLowerCase()).startsWith(key + ".")) continue;
            valueFound = true;
            String subst = key2.substring((key + ".").length());
            String[] ss = subst.split("\\.");
            try {
                int value = Integer.parseInt(ss[0]);
                count = value > count ? value : count;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return valueFound ? count + 1 : count;
    }

    public static synchronized Iterator<Object[]> getDataFromSpreadsheet(Class<?> clazz, String filename, Filter filter, boolean readHeaders) throws Exception {
        return SpreadSheetHelper.getDataFromSpreadsheet(clazz, filename, filter, readHeaders, true);
    }

    public static synchronized Iterator<Object[]> getDataFromSpreadsheet(Class<?> clazz, String filename, Filter filter, boolean readHeaders, boolean supportDPFilter) throws Exception {
        System.gc();
        if (filename.toLowerCase().endsWith(".csv")) {
            return CSVHelper.getDataFromCSVFile(clazz, filename, filter, readHeaders, supportDPFilter);
        }
        throw new Exception("illegal file format, only csv files are supported for now");
    }

    protected static Filter getDPFilter() {
        int idx;
        String includedTags = SeleniumTestsContextManager.getGlobalContext().getDPTagsInclude();
        String excludedTags = SeleniumTestsContextManager.getGlobalContext().getDPTagsExclude();
        Filter dpFilter = null;
        if (includedTags != null && includedTags.trim().length() > 0) {
            String[] includeTagsArray = includedTags.split(",");
            for (idx = 0; includeTagsArray.length > 0 && idx < includeTagsArray.length; ++idx) {
                dpFilter = dpFilter == null ? Filter.containsIgnoreCase("TestEntity.TestTags", "[" + includeTagsArray[0].trim() + "]") : Filter.or(dpFilter, Filter.containsIgnoreCase("TestEntity.TestTags", "[" + includeTagsArray[idx].trim() + "]"));
            }
        }
        if (excludedTags != null && excludedTags.trim().length() > 0) {
            String[] excludeTagsArray = excludedTags.split(",");
            for (idx = 0; excludeTagsArray.length > 0 && idx < excludeTagsArray.length; ++idx) {
                dpFilter = dpFilter == null ? Filter.not(Filter.containsIgnoreCase("TestEntity.TestTags", "[" + excludeTagsArray[idx].trim() + "]")) : Filter.and(dpFilter, Filter.not(Filter.containsIgnoreCase("TestEntity.TestTags", "[" + excludeTagsArray[idx].trim() + "]")));
            }
        }
        return dpFilter;
    }

    public static Iterator<Object[]> getEntitiesFromSpreadsheet(Class<?> clazz, LinkedHashMap<String, Class<?>> entityClazzMap, String filename, Filter filter) throws Exception {
        Iterator<Object[]> dataIterator = SpreadSheetHelper.getDataFromSpreadsheet(clazz, filename, filter, true);
        List<Object[]> list = SpreadSheetHelper.getEntityData(dataIterator, entityClazzMap);
        return list.iterator();
    }

    private static List<Object[]> getEntityData(Iterator<Object[]> dataIterator, LinkedHashMap<String, Class<?>> entityClazzMap) throws Exception {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Object[] headerArray = null;
        if (dataIterator.hasNext()) {
            headerArray = dataIterator.next();
        }
        while (dataIterator.hasNext()) {
            Object[] rowDataArray = dataIterator.next();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            ArrayList<Object> rowData = new ArrayList<Object>();
            for (int j = 0; j < headerArray.length; ++j) {
                String header = (String)headerArray[j];
                map.put(header, rowDataArray[j]);
            }
            HashMap temp = new HashMap();
            if (entityClazzMap != null) {
                for (Map.Entry entry : entityClazzMap.entrySet()) {
                    temp.put(entry.getKey(), Boolean.TRUE);
                    rowData.add(SpreadSheetHelper.readObject((Class)entry.getValue(), (String)entry.getKey(), map));
                }
            }
            for (int i = rowDataArray.length - 1; i >= 0; --i) {
                int n = ((String)headerArray[i]).indexOf(".");
                if (n < 0) {
                    rowData.add(0, rowDataArray[i]);
                    continue;
                }
                if (temp.get(((String)headerArray[i]).substring(0, n)) != null) continue;
                rowData.add(0, rowDataArray[i]);
            }
            list.add(rowData.toArray(new Object[]{rowData.size()}));
        }
        return list;
    }

    public static Map<String, Object> getFieldsDataNeedToBeSet(Map<String, Object> map, String key) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String key2 : map.keySet()) {
            if (key2.equalsIgnoreCase(key) && map.get(key2) != null) {
                result.put(key2, map.get(key2).toString());
            }
            if (!key2.toLowerCase().startsWith(key.toLowerCase() + ".") || map.get(key2) == null) continue;
            result.put(key2.substring(key.length() + 1), map.get(key2).toString());
        }
        return result;
    }

    public static Map<String, Object> getFieldsNeedToBeSet(Map<String, Object> map, String key) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String lastKey = "";
        for (String key2 : map.keySet()) {
            if (key2.equalsIgnoreCase(key)) {
                result.put(key2, map.get(key2));
            }
            if (!key2.toLowerCase().startsWith(key.toLowerCase() + ".")) continue;
            String newkey = key2.substring(key.length() + 1);
            if (newkey.contains(".")) {
                newkey = newkey.substring(0, newkey.indexOf("."));
            }
            if (newkey.equalsIgnoreCase(lastKey)) continue;
            result.put(newkey, map.get(key2));
        }
        return result;
    }

    private static Class<?> getListItemType(Type type) throws ClassNotFoundException {
        Class<?> itemClz = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            itemClz = Class.forName(pt.getActualTypeArguments()[0].toString().substring("class ".length()));
        }
        return itemClz;
    }

    public static Object getValue(Map<String, Object> map, String key) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if ((entry.getKey() != null || key != null) && (entry.getKey() == null || !entry.getKey().equalsIgnoreCase(key))) continue;
            return entry.getValue();
        }
        return null;
    }

    private static boolean isPrimitive(Class<?> clz) {
        return clz.isPrimitive() || clz.getCanonicalName().equals("java.lang." + clz.getSimpleName());
    }

    private static Object readFieldValue(Class<?> fieldClz, String fieldName, Map<String, Object> dataMap) throws Exception {
        Object fieldValue;
        block18: {
            fieldValue = null;
            String tempValue = (String)SpreadSheetHelper.getValue(dataMap, fieldName);
            if ((tempValue == null || tempValue.length() == 0) && (fieldClz.isEnum() || fieldClz.getName().equals("java.util.Calendar") || fieldClz.getName().equals("java.math.BigDecimal") || SpreadSheetHelper.isPrimitive(fieldClz))) {
                return null;
            }
            if (fieldClz.isEnum()) {
                try {
                    fieldValue = fieldClz.getMethod("valueOf", String.class).invoke(fieldClz, tempValue);
                }
                catch (Exception e) {
                    logger.warn((Object)"Ex", (Throwable)e);
                }
            } else if (fieldClz.getName().equals("java.util.Calendar")) {
                Calendar calendar = Calendar.getInstance();
                try {
                    calendar.setTime(new SimpleDateFormat("MM/dd/yyyy").parse(tempValue));
                }
                catch (ParseException ex) {
                    try {
                        calendar.setTime(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(tempValue));
                    }
                    catch (ParseException ex2) {
                        calendar.setTime(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz").parse(tempValue));
                    }
                }
                fieldValue = calendar;
            } else if (fieldClz.getName().equals("java.math.BigDecimal")) {
                fieldValue = new BigDecimal(tempValue);
            } else if (SpreadSheetHelper.isPrimitive(fieldClz)) {
                try {
                    if (fieldClz.getName().equals("java.lang.String")) {
                        fieldValue = tempValue;
                        break block18;
                    }
                    Constructor<?> constructor = PRIMITIVE_TYPE_MAP.containsKey(fieldClz) ? PRIMITIVE_TYPE_MAP.get(fieldClz).getConstructor(String.class) : fieldClz.getConstructor(String.class);
                    fieldValue = constructor.newInstance(tempValue);
                }
                catch (Exception e) {
                    logger.warn((Object)"Ex", (Throwable)e);
                }
            } else {
                fieldValue = SpreadSheetHelper.readObject(fieldClz, fieldName, dataMap);
            }
        }
        return fieldValue;
    }

    public static Object readObject(Class<?> clz, String objectName, Map<String, Object> dataMap) throws Exception {
        Object object = null;
        if (clz == null) {
            return null;
        }
        if (objectName == null) {
            objectName = clz.getSimpleName();
        }
        Map<String, Object> fieldMap = SpreadSheetHelper.getFieldsNeedToBeSet(dataMap, objectName);
        Map<String, Object> datamap = SpreadSheetHelper.getFieldsDataNeedToBeSet(dataMap, objectName);
        for (String fieldName : fieldMap.keySet()) {
            Class[] parameterTypes;
            Method method;
            Class[] parameterTypes2;
            String first = "" + fieldName.charAt(0);
            String realfieldName = fieldName.replaceFirst(first, first.toLowerCase());
            Object fieldValue = null;
            Class type = null;
            try {
                parameterTypes2 = new Class[]{};
                method = clz.getMethod("get" + fieldName, parameterTypes2);
                type = method.getReturnType();
                fieldValue = SpreadSheetHelper._readFieldValueObject(type, method.getGenericReturnType(), datamap, fieldName);
            }
            catch (NoSuchMethodException ex) {
                try {
                    parameterTypes = new Class[]{};
                    Method method2 = clz.getMethod("is" + fieldName, parameterTypes);
                    type = method2.getReturnType();
                    fieldValue = SpreadSheetHelper._readFieldValueObject(type, method2.getGenericReturnType(), datamap, fieldName);
                }
                catch (NoSuchMethodException ex2) {
                    try {
                        Field field = clz.getDeclaredField(realfieldName);
                        fieldValue = SpreadSheetHelper._readFieldValueObject(field.getType(), field.getGenericType(), datamap, fieldName);
                    }
                    catch (NoSuchFieldException ex3) {
                        try {
                            fieldValue = SpreadSheetHelper._readFieldValueObject(String.class, String.class, datamap, fieldName);
                            type = String.class;
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Ex:" + clz.getName()), (Throwable)e);
                        }
                    }
                }
            }
            try {
                if (fieldValue != null && object == null) {
                    try {
                        object = clz.newInstance();
                    }
                    catch (InstantiationException e) {
                        parameterTypes = new Class[]{fieldValue.getClass()};
                        Constructor<?> constructor = clz.getDeclaredConstructor(parameterTypes);
                        constructor.setAccessible(true);
                        object = constructor.newInstance(fieldValue);
                        return object;
                    }
                }
                if (fieldValue == null) continue;
                if (object == null) {
                    object = clz.newInstance();
                }
                try {
                    parameterTypes2 = new Class[]{type};
                    method = object.getClass().getMethod("set" + fieldName, parameterTypes2);
                    method.invoke(object, fieldValue);
                }
                catch (Exception ex) {
                    Field field2 = object.getClass().getDeclaredField(realfieldName);
                    field2.setAccessible(true);
                    field2.set(object, fieldValue);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Ex", (Throwable)e);
            }
        }
        return object;
    }

    static {
        PRIMITIVE_TYPE_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TYPE_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TYPE_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_TYPE_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_TYPE_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TYPE_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_TYPE_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_TYPE_MAP.put(Double.TYPE, Double.class);
    }
}

