/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.webelements;

import com.seleniumtests.core.TestLogging;
import com.seleniumtests.driver.WebUIDriver;
import com.seleniumtests.webelements.HtmlElement;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.UnexpectedTagNameException;

public class SelectList
extends HtmlElement {
    protected Select select = null;
    protected List<WebElement> options = null;

    public SelectList(String text, By by) {
        super(text, by);
    }

    public void deselectAll() {
        TestLogging.logWebStep("deselect all options on " + this.toHTML(), false);
        this.findElement();
        if (!this.isMultiple()) {
            throw new UnsupportedOperationException("You may only deselect all options of a multi-select");
        }
        for (WebElement option : this.options) {
            if (!option.isSelected()) continue;
            option.click();
        }
    }

    public void deselectByIndex(int index) {
        TestLogging.logWebStep("deselect index\"" + index + "\" on " + this.toHTML(), false);
        this.findElement();
        WebElement option = this.options.get(index);
        if (option.isSelected()) {
            option.click();
        }
    }

    public void deselectByText(String text) {
        TestLogging.logWebStep("deselect text\"" + text + "\" on " + this.toHTML(), false);
        this.findElement();
        for (WebElement option : this.options) {
            if (!option.getAttribute("text").equals(text)) continue;
            if (!option.isSelected()) break;
            option.click();
            break;
        }
    }

    public void deselectByValue(String value) {
        TestLogging.logWebStep("deselect value\"" + value + "\" on " + this.toHTML(), false);
        this.findElement();
        for (WebElement option : this.options) {
            if (!option.getAttribute("value").equals(value)) continue;
            if (!option.isSelected()) break;
            option.click();
            break;
        }
    }

    @Override
    protected void findElement() {
        block2: {
            this.driver = WebUIDriver.getWebDriver();
            this.element = this.driver.findElement(this.getBy());
            try {
                this.select = this.getNewSelectElement(this.element);
                this.options = this.select.getOptions();
            }
            catch (UnexpectedTagNameException e) {
                if (!this.element.getTagName().equalsIgnoreCase("ul")) break block2;
                this.options = this.element.findElements(By.tagName((String)"li"));
            }
        }
    }

    protected Select getNewSelectElement(WebElement element) {
        return new Select(element);
    }

    public List<WebElement> getOptions() {
        this.findElement();
        return this.options;
    }

    public String getSelectedText() {
        this.findElement();
        for (WebElement option : this.options) {
            if (!option.isSelected()) continue;
            return option.getAttribute("text");
        }
        return null;
    }

    public String[] getSelectedTexts() {
        this.findElement();
        ArrayList<String> textList = new ArrayList<String>();
        for (WebElement option : this.options) {
            if (!option.isSelected()) continue;
            textList.add(option.getAttribute("text"));
        }
        String[] texts = new String[textList.size()];
        return textList.toArray(texts);
    }

    public String getSelectedValue() {
        this.findElement();
        for (WebElement option : this.options) {
            if (!option.isSelected()) continue;
            return option.getAttribute("value");
        }
        return null;
    }

    public String[] getSelectedValues() {
        this.findElement();
        ArrayList<String> valueList = new ArrayList<String>();
        for (WebElement option : this.options) {
            if (!option.isSelected()) continue;
            valueList.add(option.getAttribute("value"));
        }
        String[] values = new String[valueList.size()];
        return valueList.toArray(values);
    }

    @Override
    public void init() {
        block2: {
            super.init();
            try {
                this.select = this.getNewSelectElement(this.element);
                this.options = this.select.getOptions();
            }
            catch (UnexpectedTagNameException e) {
                if (!this.element.getTagName().equalsIgnoreCase("ul")) break block2;
                this.options = this.element.findElements(By.tagName((String)"li"));
            }
        }
    }

    public boolean isMultiple() {
        this.findElement();
        String value = this.element.getAttribute("multiple");
        return value != null && !"false".equals(value);
    }

    public void selectByIndex(int index) {
        TestLogging.logWebStep("make selection using index\"" + index + "\" on " + this.toHTML(), false);
        this.findElement();
        WebElement option = this.options.get(index);
        this.setSelected(option);
    }

    public void selectByIndex(int[] indexs) {
        TestLogging.logWebStep("make selection using indexs\"" + indexs.toString() + "\" on " + this.toHTML(), false);
        this.findElement();
        for (int i = 0; i < indexs.length; ++i) {
            WebElement option = this.options.get(indexs[i]);
            this.setSelected(option);
        }
    }

    public void selectByText(String text) {
        TestLogging.logWebStep("make selection using text\"" + text + "\" on " + this.toHTML(), false);
        this.findElement();
        if (this.options == null) {
            this.driver.findElement(By.xpath((String)("//li[text()='" + text + "']"))).click();
            return;
        }
        for (WebElement option : this.options) {
            String selectedText = null;
            selectedText = option.getTagName().equalsIgnoreCase("li") ? option.getAttribute("title") : option.getAttribute("text");
            if (!selectedText.equals(text)) continue;
            this.setSelected(option);
            break;
        }
    }

    public void selectByText(String[] texts) {
        TestLogging.logWebStep("make selection using texts\"" + texts + "\" on " + this.toHTML(), false);
        this.findElement();
        block0: for (int i = 0; i < texts.length; ++i) {
            for (WebElement option : this.options) {
                if (!option.getAttribute("text").equals(texts[i])) continue;
                this.setSelected(option);
                continue block0;
            }
        }
    }

    public void selectByValue(String value) {
        TestLogging.logWebStep("make selection using value\"" + value + "\" on " + this.toHTML(), false);
        this.findElement();
        for (WebElement option : this.options) {
            if (!option.getAttribute("value").equals(value)) continue;
            this.setSelected(option);
            break;
        }
    }

    public void selectByValue(String[] values) {
        TestLogging.logWebStep("make selection using values\"" + values + "\" on " + this.toHTML(), false);
        this.findElement();
        block0: for (int i = 0; i < values.length; ++i) {
            for (WebElement option : this.options) {
                if (!option.getAttribute("value").equals(values[i])) continue;
                this.setSelected(option);
                continue block0;
            }
        }
    }

    private void setSelected(WebElement option) {
        if (!option.isSelected()) {
            option.click();
        }
    }
}

