/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.webelements;

import com.seleniumtests.core.TestLogging;
import com.seleniumtests.driver.ScreenShot;
import com.seleniumtests.driver.ScreenshotUtil;
import com.seleniumtests.webelements.BasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public abstract class WebPageSection
extends BasePage {
    private String name = null;
    private String locator = null;
    protected WebElement element = null;
    private By by = null;

    public WebPageSection(String name) {
        this.name = name;
    }

    public WebPageSection(String name, By by) {
        this.name = name;
        this.by = by;
    }

    @Override
    public void capturePageSnapshot() {
        ScreenShot screenShot = new ScreenshotUtil(this.driver).captureWebPageSnapshot();
        String title = screenShot.getTitle();
        String url = screenShot.getLocation();
        TestLogging.logWebOutput(url, title + " (" + TestLogging.buildScreenshotLog(screenShot) + ")", false);
    }

    public String getLocator() {
        return this.locator;
    }

    public String getName() {
        return this.name;
    }

    public By getBy() {
        return this.by;
    }

    public boolean isPageSectionPresent() {
        return this.isElementPresent(this.by);
    }
}

