/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.xmldog;

import com.seleniumtests.xmldog.NodeDescription;
import com.seleniumtests.xmldog.XNode;

public class Difference {
    private int _id;
    private final String _description;
    private boolean _recoverable;
    private XNode _xControlNode = null;
    private XNode _xTestNode = null;

    protected Difference(int id, String description) {
        this(id, description, false);
    }

    protected Difference(int id, String description, boolean recoverable) {
        this._id = id;
        this._description = description;
        this._recoverable = recoverable;
    }

    protected Difference(Difference prototype, XNode xControlNode, XNode xTestNode) {
        this(prototype.getId(), prototype.getDescription(), prototype.isRecoverable());
        this._xControlNode = xControlNode;
        this._xTestNode = xTestNode;
    }

    public int getId() {
        return this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    public String getDescription() {
        return this._description;
    }

    public boolean isRecoverable() {
        return this._recoverable;
    }

    protected void setRecoverable(boolean overrideValue) {
        this._recoverable = overrideValue;
    }

    public XNode getControlNodeDetail() {
        return this._xControlNode;
    }

    public void setControlNodeDetail(XNode XNode2) {
        this._xControlNode = XNode2;
    }

    public XNode getTestNodeDetail() {
        return this._xTestNode;
    }

    public void setTestNodeDetail(XNode XNode2) {
        this._xTestNode = XNode2;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this._xControlNode == null || this._xTestNode == null) {
            this.appendBasicRepresentation(buf);
        } else {
            this.appendDetailedRepresentation(buf);
        }
        return buf.toString();
    }

    private void appendBasicRepresentation(StringBuffer buf) {
        buf.append("Difference (#").append(this._id).append(") ").append(this._description);
    }

    private void appendDetailedRepresentation(StringBuffer buf) {
        buf.append("Expected ").append(this.getDescription()).append(" '").append(this._xControlNode.getValue()).append("' but was '").append(this._xTestNode.getValue()).append("' - comparing ");
        NodeDescription.appendNodeDetail(buf, this._xControlNode);
        buf.append(" to ");
        NodeDescription.appendNodeDetail(buf, this._xTestNode);
    }
}

