/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.xmldog;

import com.seleniumtests.xmldog.DifferenceListener;
import com.seleniumtests.xmldog.NodeResult;
import com.seleniumtests.xmldog.StringUtil;
import java.util.ArrayList;
import org.w3c.dom.Node;

public class Differences
extends ArrayList
implements DifferenceListener {
    public Differences() {
    }

    public Differences(Differences differences) {
        this.addAll(differences);
    }

    @Override
    public boolean add(NodeResult nr) {
        if (nr != null && nr.getDifferences() != null) {
            this.addAll(nr.getDifferences());
            return true;
        }
        return false;
    }

    @Override
    public boolean add(Differences diffs) {
        return this.addAll(diffs);
    }

    @Override
    public boolean add(Object obj) {
        if (obj instanceof NodeResult) {
            return this.add((NodeResult)obj);
        }
        if (obj instanceof Differences) {
            return this.add((Differences)obj);
        }
        return super.add(obj.toString());
    }

    @Override
    public void similarNodeFound(Node controlNode, Node testNode, String msg) {
        this.add(msg);
    }

    @Override
    public void identicalNodeFound(Node controlNode, Node testNode, String msg) {
        this.add(msg);
    }

    @Override
    public void nodeNotFound(Node controlNode, Node testNode, String msg) {
        this.add(msg);
    }

    public int getDiffCount() {
        return this.size();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Differences:[ size: " + this.size());
        sb.append(StringUtil.getNewlineStr());
        if (this.size() > 0) {
            for (int i = 0; i < this.size(); ++i) {
                sb.append(this.get(i).toString());
                sb.append(StringUtil.getNewlineStr());
            }
        } else {
            sb.append("XML Nodes are identical, No differences found");
        }
        sb.append(StringUtil.getNewlineStr());
        sb.append("]");
        return sb.toString();
    }

    public String getHTML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<UL>");
        if (this.size() > 0) {
            for (int i = 0; i < this.size(); ++i) {
                sb.append("<LI>");
                sb.append(this.get(i).toString());
                sb.append("</LI>");
            }
        } else {
            sb.append("<B>Nodes are identical, No differences found</B>");
        }
        sb.append("</UL>");
        return sb.toString();
    }
}

