/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.xmldog;

import com.seleniumtests.xmldog.Differences;
import com.seleniumtests.xmldog.StringUtil;
import com.seleniumtests.xmldog.XMLUtil;
import com.seleniumtests.xmldog.XNode;
import java.io.Serializable;

public class NodeResult
implements Serializable {
    private XNode _testNode = null;
    private XNode _controlNode = null;
    private Differences _differences = null;
    private boolean _uniqueAttrMatch = false;
    private boolean _isExactMatch = false;

    public NodeResult() {
    }

    public NodeResult(XNode controlNode, XNode testNode, Differences diff) {
        this._controlNode = controlNode;
        this._testNode = testNode;
        this._differences = diff;
    }

    public XNode getTestNode() {
        return this._testNode;
    }

    public void setTestNode(XNode node) {
        this._testNode = node;
    }

    public XNode getControlNode() {
        return this._controlNode;
    }

    public void setControlNode(XNode node) {
        this._controlNode = node;
    }

    public Differences getDifferences() {
        return this._differences;
    }

    public void setDifferences(Differences diff) {
        this._differences = diff;
    }

    public boolean isUniqueAttrMatch() {
        return this._uniqueAttrMatch;
    }

    public void setUniqueAttrMatch(boolean flag) {
        this._uniqueAttrMatch = flag;
    }

    public boolean isExactMatch() {
        return this._isExactMatch;
    }

    public void setIfExactMatch(boolean flag) {
        this._isExactMatch = flag;
    }

    public boolean isMatch() {
        return this.isExactMatch() || this.isUniqueAttrMatch();
    }

    public int getNumDifferences() {
        if (this._differences == null) {
            return 0;
        }
        return this._differences.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("NodeResult[");
        sb.append(StringUtil.getNewlineStr());
        sb.append("Golden");
        sb.append(XMLUtil.getNodeBasics(this.getControlNode().getNode()));
        sb.append(StringUtil.getNewlineStr());
        sb.append("Current");
        sb.append(StringUtil.getNewlineStr());
        sb.append(XMLUtil.getNodeBasics(this.getTestNode().getNode()));
        sb.append(StringUtil.getNewlineStr());
        sb.append(this.getDifferences());
        sb.append(StringUtil.getNewlineStr() + "]");
        return sb.toString();
    }

    public static void main(String[] args) {
    }
}

