package com.simtechdata.htmldecoder;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Decoder {

	/**
	 * Constructor in case you want to instantiate the class, but it is not necessary.
	 */
	public Decoder() {
		init();
	}

	private static final Map<String, String> encodingMap = new HashMap<>();

	/**
	 * private method to prime the decoding Map
	 */
	private static void init() {
		encodingMap.put("%20", " ");
		encodingMap.put("%21", "!");
		encodingMap.put("%22", "“");
		encodingMap.put("%23", "#");
		encodingMap.put("%24", "$");
		encodingMap.put("%25", "%");
		encodingMap.put("%26", "&");
		encodingMap.put("%27", "‘");
		encodingMap.put("%28", "(");
		encodingMap.put("%29", ")");
		encodingMap.put("%2A", "*");
		encodingMap.put("%2B", "+");
		encodingMap.put("%2C", ",");
		encodingMap.put("%2D", "–");
		encodingMap.put("%2E", ".");
		encodingMap.put("%2F", "/");
		encodingMap.put("%30", "0");
		encodingMap.put("%31", "1");
		encodingMap.put("%32", "2");
		encodingMap.put("%33", "3");
		encodingMap.put("%34", "4");
		encodingMap.put("%35", "5");
		encodingMap.put("%36", "6");
		encodingMap.put("%37", "7");
		encodingMap.put("%38", "8");
		encodingMap.put("%39", "9");
		encodingMap.put("%3A", ":");
		encodingMap.put("%3B", ";");
		encodingMap.put("%3C", "<");
		encodingMap.put("%3D", "=");
		encodingMap.put("%3E", ">");
		encodingMap.put("%3F", "?");
		encodingMap.put("%40", "@");
		encodingMap.put("%41", "A");
		encodingMap.put("%42", "B");
		encodingMap.put("%43", "C");
		encodingMap.put("%44", "D");
		encodingMap.put("%45", "E");
		encodingMap.put("%46", "F");
		encodingMap.put("%47", "G");
		encodingMap.put("%48", "H");
		encodingMap.put("%49", "I");
		encodingMap.put("%4A", "J");
		encodingMap.put("%4B", "K");
		encodingMap.put("%4C", "L");
		encodingMap.put("%4D", "M");
		encodingMap.put("%4E", "N");
		encodingMap.put("%4F", "O");
		encodingMap.put("%50", "P");
		encodingMap.put("%51", "Q");
		encodingMap.put("%52", "R");
		encodingMap.put("%53", "S");
		encodingMap.put("%54", "T");
		encodingMap.put("%55", "U");
		encodingMap.put("%56", "V");
		encodingMap.put("%57", "W");
		encodingMap.put("%58", "X");
		encodingMap.put("%59", "Y");
		encodingMap.put("%5A", "Z");
		encodingMap.put("%5B", "[");
		encodingMap.put("%5C", " ");
		encodingMap.put("%5D", "]");
		encodingMap.put("%5E", "^");
		encodingMap.put("%5F", "_");
		encodingMap.put("%60", "`");
		encodingMap.put("%61", "a");
		encodingMap.put("%62", "b");
		encodingMap.put("%63", "c");
		encodingMap.put("%64", "d");
		encodingMap.put("%65", "e");
		encodingMap.put("%66", "f");
		encodingMap.put("%67", "g");
		encodingMap.put("%68", "h");
		encodingMap.put("%69", "i");
		encodingMap.put("%6A", "j");
		encodingMap.put("%6B", "k");
		encodingMap.put("%6C", "l");
		encodingMap.put("%6D", "m");
		encodingMap.put("%6E", "n");
		encodingMap.put("%6F", "o");
		encodingMap.put("%70", "p");
		encodingMap.put("%71", "q");
		encodingMap.put("%72", "r");
		encodingMap.put("%73", "s");
		encodingMap.put("%74", "t");
		encodingMap.put("%75", "u");
		encodingMap.put("%76", "v");
		encodingMap.put("%77", "w");
		encodingMap.put("%78", "x");
		encodingMap.put("%79", "y");
		encodingMap.put("%7A", "z");
		encodingMap.put("%7B", "{");
		encodingMap.put("%7C", "|");
		encodingMap.put("%7D", "}");
		encodingMap.put("%7E", "~");
		encodingMap.put("%7F", " ");
		encodingMap.put("%80", "€");
		encodingMap.put("%81", " ");
		encodingMap.put("%82", "‚");
		encodingMap.put("%83", "ƒ");
		encodingMap.put("%84", "„");
		encodingMap.put("%85", "…");
		encodingMap.put("%86", "†");
		encodingMap.put("%87", "‡");
		encodingMap.put("%88", "ˆ");
		encodingMap.put("%89", "‰");
		encodingMap.put("%8A", "Š");
		encodingMap.put("%8B", "‹");
		encodingMap.put("%8C", "Œ");
		encodingMap.put("%8D", " ");
		encodingMap.put("%8E", "Ž");
		encodingMap.put("%8F", " ");
		encodingMap.put("%90", " ");
		encodingMap.put("%91", "‘");
		encodingMap.put("%92", "’");
		encodingMap.put("%93", "“");
		encodingMap.put("%94", "”");
		encodingMap.put("%95", "•");
		encodingMap.put("%96", "–");
		encodingMap.put("%97", "—");
		encodingMap.put("%98", "˜");
		encodingMap.put("%99", "™");
		encodingMap.put("%9A", "š");
		encodingMap.put("%9B", "›");
		encodingMap.put("%9C", "œ");
		encodingMap.put("%9D", " ");
		encodingMap.put("%9E", "ž");
		encodingMap.put("%9F", "Ÿ");
		encodingMap.put("%A0", " ");
		encodingMap.put("%A1", "¡");
		encodingMap.put("%A2", "¢");
		encodingMap.put("%A3", "£");
		encodingMap.put("%A4", " ");
		encodingMap.put("%A5", "¥");
		encodingMap.put("%A6", "|");
		encodingMap.put("%A7", "§");
		encodingMap.put("%A8", "¨");
		encodingMap.put("%A9", "©");
		encodingMap.put("%AA", "ª");
		encodingMap.put("%AB", "«");
		encodingMap.put("%AC", "¬");
		encodingMap.put("%AD", "¯");
		encodingMap.put("%AE", "®");
		encodingMap.put("%AF", "¯");
		encodingMap.put("%B0", "°");
		encodingMap.put("%B1", "±");
		encodingMap.put("%B2", "²");
		encodingMap.put("%B3", "³");
		encodingMap.put("%B4", "´");
		encodingMap.put("%B5", "µ");
		encodingMap.put("%B6", "¶");
		encodingMap.put("%B7", "·");
		encodingMap.put("%B8", "¸");
		encodingMap.put("%B9", "¹");
		encodingMap.put("%BA", "º");
		encodingMap.put("%BB", "»");
		encodingMap.put("%BC", "¼");
		encodingMap.put("%BD", "½");
		encodingMap.put("%BE", "¾");
		encodingMap.put("%BF", "¿");
		encodingMap.put("%C0", "À");
		encodingMap.put("%C1", "Á");
		encodingMap.put("%C2", " ");
		encodingMap.put("%C3", "Ã");
		encodingMap.put("%C4", "Ä");
		encodingMap.put("%C5", "Å");
		encodingMap.put("%C6", "Æ");
		encodingMap.put("%C7", "Ç");
		encodingMap.put("%C8", "È");
		encodingMap.put("%C9", "É");
		encodingMap.put("%CA", " ");
		encodingMap.put("%CB", "Ë");
		encodingMap.put("%CC", "Ì");
		encodingMap.put("%CD", "Í");
		encodingMap.put("%CE", "Î");
		encodingMap.put("%CF", "Ï");
		encodingMap.put("%D0", "Ð");
		encodingMap.put("%D1", "Ñ");
		encodingMap.put("%D2", "Ò");
		encodingMap.put("%D3", "Ó");
		encodingMap.put("%D4", "Ô");
		encodingMap.put("%D5", "Õ");
		encodingMap.put("%D6", "Ö");
		encodingMap.put("%D7", " ");
		encodingMap.put("%D8", "Ø");
		encodingMap.put("%D9", "Ù");
		encodingMap.put("%DA", "Ú");
		encodingMap.put("%DB", "Û");
		encodingMap.put("%DC", "Ü");
		encodingMap.put("%DD", "Ý");
		encodingMap.put("%DE", "Þ");
		encodingMap.put("%DF", "ß");
		encodingMap.put("%E0", "à");
		encodingMap.put("%E1", "á");
		encodingMap.put("%E2", "â");
		encodingMap.put("%E3", "ã");
		encodingMap.put("%E4", "ä");
		encodingMap.put("%E5", "å");
		encodingMap.put("%E6", "æ");
		encodingMap.put("%E7", "ç");
		encodingMap.put("%E8", "è");
		encodingMap.put("%E9", "é");
		encodingMap.put("%EA", "ê");
		encodingMap.put("%EB", "ë");
		encodingMap.put("%EC", "ì");
		encodingMap.put("%ED", "í");
		encodingMap.put("%EE", "î");
		encodingMap.put("%EF", "ï");
		encodingMap.put("%F0", "ð");
		encodingMap.put("%F1", "ñ");
		encodingMap.put("%F2", "ò");
		encodingMap.put("%F3", "ó");
		encodingMap.put("%F4", "ô");
		encodingMap.put("%F5", "õ");
		encodingMap.put("%F6", "ö");
		encodingMap.put("%F7", "÷");
		encodingMap.put("%F8", "ø");
		encodingMap.put("%F9", "ù");
		encodingMap.put("%FA", "ú");
		encodingMap.put("%FB", "û");
		encodingMap.put("%FC", "ü");
		encodingMap.put("%FD", "ý");
		encodingMap.put("%FE", "þ");
		encodingMap.put("%FF", "ÿ");
	}

	/**
	 * public method that will take a single HTML code and return its translated value.
	 * @param code - A String of the code you need to translate (ie %20)
	 * @return - String of the translated value
	 */
	public static String get(String code) {
		if(encodingMap.size() == 0) init();
		return encodingMap.get(code);
	}

	/**
	 * method that will extract all the HTML codes from an entire string and return the same string with the codes replaced with their translations.
	 * @param text - the String you need to convert.
	 * @return - String with the codes replaced with their translations.
	 */
	public static String decode(String text) {
		LinkedList<String> codes = getCodes(text);
		for(String search : codes) {
			String replace = get(search.toUpperCase());
			text = text.replaceAll(search,replace);
		}
		return text;
	}

	/**
	 * private method that extracts all the HTML codes from a String and returns a list containing all of the codes.
	 * @param text - the String to be searched
	 * @return - LinkedList<String> containing all the codes inside the String.
	 */
	private static LinkedList<String> getCodes(String text) {
		LinkedList<String> codes = new LinkedList<>();
		String regex = "%[0-9a-fA-F]{2}";
		Pattern p = Pattern.compile(regex);
		Matcher m = p.matcher(text);
		while(m.find()) {
			codes.addLast(m.group(0));
		}
		return codes;
	}
}
