/*
 * Decompiled with CFR 0.152.
 */
package com.simtechdata.process;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class ProcResult {
    private final String procString;
    private final ByteArrayOutputStream output;
    private final int exitValue;
    private final long executionTime;
    private final byte[] err;

    ProcResult(String procString, ByteArrayOutputStream output, int exitValue, long executionTime, byte[] err) {
        this.procString = procString;
        this.output = output;
        this.exitValue = exitValue;
        this.executionTime = executionTime;
        this.err = err != null ? Arrays.copyOf(err, err.length) : null;
    }

    @Deprecated
    public String getProcString() {
        return this.procString;
    }

    public String getCommandLine() {
        return this.procString;
    }

    private ByteArrayOutputStream getOutputStream() throws IllegalStateException {
        if (this.output == null) {
            throw new IllegalStateException("Output has been consumed by client provided OutputStream");
        }
        return this.output;
    }

    public String getOutputString() throws IllegalStateException {
        return this.getOutputStream().toString();
    }

    public byte[] getOutputBytes() throws IllegalStateException {
        return this.getOutputStream().toByteArray();
    }

    public String getErrorString() throws IllegalStateException {
        return new String(this.getErrorBytes());
    }

    public byte[] getErrorBytes() throws IllegalStateException {
        if (this.err == null) {
            throw new IllegalStateException("Error output has been consumed by client provided OutputStream");
        }
        return this.err;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }
}

