/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common;

import com.google.common.base.Objects;
import com.stackify.api.EnvironmentDetail;

public class ApiConfiguration {
    private static final String DEFAULT_API_URL = "https://api.stackify.com";
    private final String apiUrl;
    private final String apiKey;
    private final String application;
    private final String environment;
    private final EnvironmentDetail envDetail;

    public String getApiUrl() {
        return this.apiUrl != null ? this.apiUrl : DEFAULT_API_URL;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApplication() {
        return this.application;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public EnvironmentDetail getEnvDetail() {
        return this.envDetail;
    }

    private ApiConfiguration(Builder builder) {
        this.apiUrl = builder.apiUrl;
        this.apiKey = builder.apiKey;
        this.application = builder.application;
        this.environment = builder.environment;
        this.envDetail = builder.envDetail;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ApiConfiguration.newBuilder().apiUrl(this.apiUrl).apiKey(this.apiKey).application(this.application).environment(this.environment).envDetail(this.envDetail);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("apiUrl", (Object)this.apiUrl).add("apiKey", (Object)this.apiKey).add("application", (Object)this.application).add("environment", (Object)this.environment).add("envDetail", (Object)this.envDetail).toString();
    }

    public static class Builder {
        private String apiUrl;
        private String apiKey;
        private String application;
        private String environment;
        private EnvironmentDetail envDetail;

        public Builder apiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder application(String application) {
            this.application = application;
            return this;
        }

        public Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder envDetail(EnvironmentDetail envDetail) {
            this.envDetail = envDetail;
            return this;
        }

        public ApiConfiguration build() {
            return new ApiConfiguration(this);
        }
    }
}

