/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.lang;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingQueue;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;

public class EvictingQueue<E>
extends ForwardingQueue<E> {
    private final int maxSize;
    private final Queue<E> deque;

    public EvictingQueue(int maxSize) {
        Preconditions.checkArgument((0 < maxSize ? 1 : 0) != 0);
        this.maxSize = maxSize;
        this.deque = new ArrayDeque(maxSize);
    }

    protected Queue<E> delegate() {
        return this.deque;
    }

    public boolean offer(E element) {
        return this.add(element);
    }

    public boolean add(E element) {
        Preconditions.checkNotNull(element);
        if (this.deque.size() == this.maxSize) {
            this.deque.remove();
        }
        this.deque.add(element);
        return true;
    }

    public boolean addAll(Collection<? extends E> collection) {
        Preconditions.checkNotNull(collection);
        for (E element : collection) {
            this.add(element);
        }
        return true;
    }
}

