/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.http;

import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.http.HttpException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPOutputStream;

public class HttpClient {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;
    private final ApiConfiguration apiConfig;

    public HttpClient(ApiConfiguration apiConfig) {
        Preconditions.checkNotNull((Object)apiConfig);
        this.apiConfig = apiConfig;
    }

    public String post(String path, byte[] jsonBytes) throws IOException, HttpException {
        return this.post(path, jsonBytes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(String path, byte[] jsonBytes, boolean gzip) throws IOException, HttpException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)jsonBytes);
        Preconditions.checkArgument((0 < jsonBytes.length ? 1 : 0) != 0);
        URLConnection connection = null;
        try {
            URL url = new URL(this.apiConfig.getApiUrl() + path);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            if (gzip) {
                connection.setRequestProperty("Content-Encoding", "gzip");
            }
            connection.setRequestProperty("X-Stackify-Key", this.apiConfig.getApiKey());
            connection.setRequestProperty("X-Stackify-PV", "V1");
            ((HttpURLConnection)connection).setRequestMethod("POST");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            BufferedOutputStream stream = null;
            stream = gzip ? new BufferedOutputStream(new GZIPOutputStream(connection.getOutputStream())) : new BufferedOutputStream(connection.getOutputStream());
            ((OutputStream)stream).write(jsonBytes);
            ((OutputStream)stream).flush();
            ((OutputStream)stream).close();
            int statusCode = ((HttpURLConnection)connection).getResponseCode();
            if (statusCode != 200) {
                throw new HttpException(statusCode);
            }
            String string = this.readAndClose(connection.getInputStream());
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    this.readAndClose(connection.getInputStream());
                }
                catch (Throwable t) {}
                try {
                    this.readAndClose(((HttpURLConnection)connection).getErrorStream());
                }
                catch (Throwable t) {}
            }
        }
    }

    private String readAndClose(InputStream stream) throws IOException {
        Preconditions.checkNotNull((Object)stream);
        String contents = CharStreams.toString((Readable)new InputStreamReader((InputStream)new BufferedInputStream(stream), "UTF-8"));
        stream.close();
        return contents;
    }
}

