/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.http;

import java.net.InetSocketAddress;
import java.net.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpProxy.class);

    public static Proxy fromSystemProperties() {
        try {
            String proxyHost = System.getProperty("https.proxyHost");
            String proxyPort = System.getProperty("https.proxyPort");
            if (proxyHost != null && !proxyHost.isEmpty() && proxyPort != null && !proxyPort.isEmpty()) {
                return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort)));
            }
        }
        catch (Throwable t) {
            LOGGER.info("Unable to read HTTP proxy information from system properties", t);
        }
        return Proxy.NO_PROXY;
    }

    private HttpProxy() {
    }
}

