/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.http;

import com.stackify.api.common.collect.SynchronizedEvictingQueue;
import com.stackify.api.common.http.HttpClient;
import com.stackify.api.common.http.HttpException;
import com.stackify.api.common.http.HttpResendQueueItem;
import com.stackify.api.common.lang.Threads;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResendQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResendQueue.class);
    private static final int MAX_POST_ATTEMPTS = 3;
    private final Queue<HttpResendQueueItem> resendQueue;

    public HttpResendQueue(int maxSize) {
        this.resendQueue = new SynchronizedEvictingQueue<HttpResendQueueItem>(maxSize);
    }

    public int size() {
        return this.resendQueue.size();
    }

    public void offer(byte[] request, IOException e) {
        this.resendQueue.offer(new HttpResendQueueItem(request));
    }

    public void offer(byte[] request, HttpException e) {
        if (!e.isClientError()) {
            this.resendQueue.offer(new HttpResendQueueItem(request));
        }
    }

    public void drain(HttpClient httpClient, String path) {
        this.drain(httpClient, path, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drain(HttpClient httpClient, String path, boolean gzip) {
        if (this.resendQueue.isEmpty()) return;
        try {
            LOGGER.info("Attempting to retransmit {} requests", (Object)this.resendQueue.size());
            while (!this.resendQueue.isEmpty()) {
                HttpResendQueueItem item = this.resendQueue.peek();
                try {
                    byte[] jsonBytes = item.getJsonBytes();
                    httpClient.post(path, jsonBytes, gzip);
                    this.resendQueue.remove();
                    Threads.sleepQuietly(250L, TimeUnit.MILLISECONDS);
                }
                catch (Throwable t) {
                    item.failed();
                    if (3 > item.getNumFailures()) throw t;
                    this.resendQueue.remove();
                    throw t;
                    return;
                }
            }
        }
        catch (Throwable t) {
            LOGGER.info("Failure retransmitting queued requests", t);
        }
    }
}

