/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackgroundService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackgroundService.class);
    private ScheduledExecutorService executorService;
    private ScheduledFuture<Void> currentFuture;
    private final ReentrantLock lock = new ReentrantLock();

    protected abstract void startUp() throws Exception;

    protected abstract void runOneIteration() throws Exception;

    protected abstract long getNextScheduleDelayMilliseconds();

    protected abstract void shutDown() throws Exception;

    public void start() {
        this.lock.lock();
        try {
            this.executorService = Executors.newSingleThreadScheduledExecutor();
            try {
                this.startUp();
            }
            catch (Throwable t) {
                LOGGER.info("Exception in service start up", t);
            }
            this.currentFuture = this.executorService.schedule(new RunOneIterationAndReschedule(), 0L, TimeUnit.MILLISECONDS);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isRunning() {
        return this.executorService != null && !this.executorService.isShutdown() && !this.executorService.isTerminated();
    }

    public void stop() {
        this.lock.lock();
        try {
            this.currentFuture.cancel(false);
            try {
                this.shutDown();
            }
            catch (Throwable t) {
                LOGGER.info("Exception in service shut down", t);
            }
            try {
                this.executorService.shutdown();
                this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (Throwable t) {
                LOGGER.info("Exception in service termination", t);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private class RunOneIterationAndReschedule
    implements Callable<Void> {
        private RunOneIterationAndReschedule() {
        }

        @Override
        public Void call() throws Exception {
            BackgroundService.this.lock.lock();
            try {
                BackgroundService.this.runOneIteration();
            }
            catch (Throwable t) {
                LOGGER.info("Exception in iteration", t);
            }
            finally {
                BackgroundService.this.lock.unlock();
            }
            BackgroundService.this.lock.lock();
            try {
                if (!BackgroundService.this.currentFuture.isCancelled()) {
                    long nextDelay = BackgroundService.this.getNextScheduleDelayMilliseconds();
                    BackgroundService.this.currentFuture = BackgroundService.this.executorService.schedule(this, nextDelay, TimeUnit.MILLISECONDS);
                }
            }
            catch (Throwable t) {
                LOGGER.info("Exception rescheduling iteration", t);
            }
            finally {
                BackgroundService.this.lock.unlock();
            }
            return null;
        }
    }
}

