/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log.direct;

import com.stackify.api.EnvironmentDetail;
import com.stackify.api.LogMsg;
import com.stackify.api.StackifyError;
import com.stackify.api.WebRequestDetail;
import com.stackify.api.common.lang.Throwables;
import com.stackify.api.common.log.APMLogData;
import com.stackify.api.common.log.EventAdapter;
import com.stackify.api.common.log.ServletLogContext;
import com.stackify.api.common.log.direct.LogEvent;
import com.stackify.api.common.util.Maps;
import com.stackify.api.common.util.Preconditions;
import java.util.Date;

public class LogEventAdapter
implements EventAdapter<LogEvent> {
    private final EnvironmentDetail envDetail;

    public LogEventAdapter(EnvironmentDetail envDetail) {
        Preconditions.checkNotNull(envDetail);
        this.envDetail = envDetail;
    }

    @Override
    public Throwable getThrowable(LogEvent event) {
        return event.getException();
    }

    @Override
    public StackifyError getStackifyError(LogEvent event, Throwable exception) {
        WebRequestDetail webRequest;
        String user;
        StackifyError.Builder builder = StackifyError.newBuilder();
        builder.environmentDetail(this.envDetail);
        builder.occurredEpochMillis(new Date(event.getTimestamp()));
        if (exception != null) {
            builder.error(Throwables.toErrorItem(event.getMessage(), exception));
        } else {
            builder.error(Throwables.toErrorItem(event.getMessage(), event.getClassName(), event.getMethodName(), event.getLineNumber()));
        }
        String string = user = APMLogData.isLinked() ? APMLogData.getUser() : ServletLogContext.getUser();
        if (user != null) {
            builder.userName(user);
        }
        WebRequestDetail webRequestDetail = webRequest = APMLogData.isLinked() ? APMLogData.getWebRequest() : ServletLogContext.getWebRequest();
        if (webRequest != null) {
            builder.webRequestDetail(webRequest);
        }
        builder.serverVariables(Maps.fromProperties(System.getProperties()));
        return builder.build();
    }

    @Override
    public LogMsg getLogMsg(LogEvent event, StackifyError error) {
        String transactionId;
        LogMsg.Builder builder = LogMsg.newBuilder();
        builder.msg(event.getMessage());
        builder.ex(error);
        builder.epochMs(event.getTimestamp());
        if (event.getLevel() != null) {
            builder.level(event.getLevel().toLowerCase());
        }
        String string = transactionId = APMLogData.isLinked() ? APMLogData.getTransactionId() : ServletLogContext.getTransactionId();
        if (transactionId != null) {
            builder.transId(transactionId);
        }
        return builder.build();
    }

    @Override
    public boolean isErrorLevel(LogEvent event) {
        if (event.getLevel() != null) {
            return "ERROR".equals(event.getLevel().toUpperCase());
        }
        return false;
    }

    @Override
    public String getClassName(LogEvent event) {
        return event.getClassName();
    }
}

