/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common;

import com.stackify.api.EnvironmentDetail;

public class ApiConfiguration {
    public static final String TRANSPORT_DIRECT = "direct";
    public static final String TRANSPORT_AGENT_SOCKET = "agent_socket";
    private static final String DEFAULT_TRANSPORT = "direct";
    private static final String DEFAULT_AGENT_SOCKET_PATH_UNIX = "/usr/local/stackify/stackify.sock";
    private static final String DEFAULT_API_URL = "https://api.stackify.com";
    private final String apiUrl;
    private final String apiKey;
    private final String application;
    private final String environment;
    private final EnvironmentDetail envDetail;
    private final Boolean skipJson;
    private final Boolean allowComDotStackify;
    private final String httpProxyHost;
    private final String httpProxyPort;
    private final String transport;

    public String getApiUrl() {
        return this.apiUrl != null ? this.apiUrl : DEFAULT_API_URL;
    }

    public String getTransport() {
        return this.transport != null ? this.transport : "direct";
    }

    public String getAgentSocketPath() {
        return DEFAULT_AGENT_SOCKET_PATH_UNIX;
    }

    ApiConfiguration(String apiUrl, String apiKey, String application, String environment, EnvironmentDetail envDetail, Boolean skipJson, Boolean allowComDotStackify, String httpProxyHost, String httpProxyPort, String transport) {
        this.apiUrl = apiUrl;
        this.apiKey = apiKey;
        this.application = application;
        this.environment = environment;
        this.envDetail = envDetail;
        this.skipJson = skipJson;
        this.allowComDotStackify = allowComDotStackify;
        this.httpProxyHost = httpProxyHost;
        this.httpProxyPort = httpProxyPort;
        this.transport = transport;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().apiUrl(this.apiUrl).apiKey(this.apiKey).application(this.application).environment(this.environment).envDetail(this.envDetail).skipJson(this.skipJson).allowComDotStackify(this.allowComDotStackify).httpProxyHost(this.httpProxyHost).httpProxyPort(this.httpProxyPort).transport(this.transport);
    }

    public String toString() {
        return "ApiConfiguration(apiUrl=" + this.getApiUrl() + ", apiKey=" + this.getApiKey() + ", application=" + this.getApplication() + ", environment=" + this.getEnvironment() + ", envDetail=" + this.getEnvDetail() + ", skipJson=" + this.getSkipJson() + ", allowComDotStackify=" + this.getAllowComDotStackify() + ", httpProxyHost=" + this.getHttpProxyHost() + ", httpProxyPort=" + this.getHttpProxyPort() + ", transport=" + this.getTransport() + ")";
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApplication() {
        return this.application;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public EnvironmentDetail getEnvDetail() {
        return this.envDetail;
    }

    public Boolean getSkipJson() {
        return this.skipJson;
    }

    public Boolean getAllowComDotStackify() {
        return this.allowComDotStackify;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public String getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public static class Builder {
        private String apiUrl;
        private String apiKey;
        private String application;
        private String environment;
        private EnvironmentDetail envDetail;
        private Boolean skipJson;
        private Boolean allowComDotStackify;
        private String httpProxyHost;
        private String httpProxyPort;
        private String transport;

        Builder() {
        }

        public Builder apiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder application(String application) {
            this.application = application;
            return this;
        }

        public Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder envDetail(EnvironmentDetail envDetail) {
            this.envDetail = envDetail;
            return this;
        }

        public Builder skipJson(Boolean skipJson) {
            this.skipJson = skipJson;
            return this;
        }

        public Builder allowComDotStackify(Boolean allowComDotStackify) {
            this.allowComDotStackify = allowComDotStackify;
            return this;
        }

        public Builder httpProxyHost(String httpProxyHost) {
            this.httpProxyHost = httpProxyHost;
            return this;
        }

        public Builder httpProxyPort(String httpProxyPort) {
            this.httpProxyPort = httpProxyPort;
            return this;
        }

        public Builder transport(String transport) {
            this.transport = transport;
            return this;
        }

        public ApiConfiguration build() {
            return new ApiConfiguration(this.apiUrl, this.apiKey, this.application, this.environment, this.envDetail, this.skipJson, this.allowComDotStackify, this.httpProxyHost, this.httpProxyPort, this.transport);
        }

        public String toString() {
            return "ApiConfiguration.Builder(apiUrl=" + this.apiUrl + ", apiKey=" + this.apiKey + ", application=" + this.application + ", environment=" + this.environment + ", envDetail=" + this.envDetail + ", skipJson=" + this.skipJson + ", allowComDotStackify=" + this.allowComDotStackify + ", httpProxyHost=" + this.httpProxyHost + ", httpProxyPort=" + this.httpProxyPort + ", transport=" + this.transport + ")";
        }
    }
}

