/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.mask;

import com.stackify.api.common.mask.Masker;
import com.stackify.api.common.util.PropertyUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaskerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MaskerConfiguration.class);

    public static Masker fromProperties() {
        return MaskerConfiguration.fromProperties("/stackify-api.properties");
    }

    public static Masker fromProperties(String path) {
        Masker masker = new Masker();
        masker.addMask("CREDITCARD");
        masker.addMask("SSN");
        try {
            if (path != null) {
                Map<String, String> map = PropertyUtil.read(path);
                if (!map.containsKey("stackify.log.mask.enabled") || !Boolean.parseBoolean(map.get("stackify.log.mask.enabled"))) {
                    masker.clearMasks();
                    return masker;
                }
                for (String builtinMask : Masker.MASKS) {
                    if (!map.containsKey("stackify.log.mask." + builtinMask)) continue;
                    if (Boolean.parseBoolean(map.get("stackify.log.mask." + builtinMask))) {
                        masker.addMask(builtinMask);
                        continue;
                    }
                    masker.removeMask(builtinMask);
                }
                for (Object e : map.keySet()) {
                    if (!e.toString().startsWith("stackify.log.mask.custom.")) continue;
                    masker.addMask(map.get(e.toString()));
                }
            }
        }
        catch (Throwable t) {
            log.error("Exception reading " + path + " configuration file", t);
        }
        return masker;
    }
}

