/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.proto;

import com.stackify.api.Container;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.ErrorItem;
import com.stackify.api.Kubernetes;
import com.stackify.api.LogMsg;
import com.stackify.api.LogMsgGroup;
import com.stackify.api.StackifyError;
import com.stackify.api.TraceFrame;
import com.stackify.api.WebRequestDetail;
import com.stackify.api.common.proto.StackifyProto;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class LogGroupConverter {
    private static TraceFrame convert(@NonNull StackifyProto.LogGroup.Log.Error.ErrorItem.TraceFrame traceFrame) {
        if (traceFrame == null) {
            throw new NullPointerException("traceFrame is marked non-null but is null");
        }
        return TraceFrame.newBuilder().codeFileName(traceFrame.getCodeFilename()).lineNum(traceFrame.getLineNumber()).method(traceFrame.getMethod()).build();
    }

    private static ErrorItem convert(@NonNull StackifyProto.LogGroup.Log.Error.ErrorItem errorItem) {
        if (errorItem == null) {
            throw new NullPointerException("errorItem is marked non-null but is null");
        }
        ErrorItem.Builder builder = ErrorItem.newBuilder().message(errorItem.getMessage()).errorType(errorItem.getErrorType()).errorTypeCode(errorItem.getErrorTypeCode()).sourceMethod(errorItem.getSourceMethod()).innerError(errorItem.hasInnerError() ? LogGroupConverter.convert(errorItem.getInnerError()) : null);
        if (errorItem.getDataMap().size() > 0) {
            builder.data(errorItem.getDataMap());
        }
        if (errorItem.getStacktraceList().size() > 0) {
            ArrayList<TraceFrame> stackTrace = new ArrayList<TraceFrame>();
            for (StackifyProto.LogGroup.Log.Error.ErrorItem.TraceFrame traceFrame : errorItem.getStacktraceList()) {
                stackTrace.add(LogGroupConverter.convert(traceFrame));
            }
            builder.stackTrace(stackTrace);
        }
        return builder.build();
    }

    private static WebRequestDetail convert(@NonNull StackifyProto.LogGroup.Log.Error.WebRequestDetail webRequestDetail) {
        if (webRequestDetail == null) {
            throw new NullPointerException("webRequestDetail is marked non-null but is null");
        }
        return WebRequestDetail.newBuilder().userIpAddress(webRequestDetail.getUserIpAddress()).httpMethod(webRequestDetail.getHttpMethod()).requestProtocol(webRequestDetail.getRequestProtocol()).requestUrl(webRequestDetail.getRequestUrl()).requestUrlRoot(webRequestDetail.getRequestUrlRoot()).referralUrl(webRequestDetail.getReferralUrl()).headers(webRequestDetail.getHeadersMap()).cookies(webRequestDetail.getCookiesMap()).queryString(webRequestDetail.getQuerystringMap()).postData(webRequestDetail.getPostDataMap()).sessionData(webRequestDetail.getSessionDataMap()).postDataRaw(webRequestDetail.getPostDataRaw()).mvcAction(webRequestDetail.getMvcAction()).mvcController(webRequestDetail.getMvcController()).mvcArea(webRequestDetail.getMvcArea()).build();
    }

    private static EnvironmentDetail convert(@NonNull StackifyProto.LogGroup.Log.Error.EnvironmentDetail environmentDetail) {
        if (environmentDetail == null) {
            throw new NullPointerException("environmentDetail is marked non-null but is null");
        }
        return EnvironmentDetail.newBuilder().deviceName(environmentDetail.getDeviceName()).appName(environmentDetail.getApplicationName()).appLocation(environmentDetail.getApplicationLocation()).configuredAppName(environmentDetail.getConfiguredApplicationName()).configuredEnvironmentName(environmentDetail.getConfiguredEnvironmentName()).build();
    }

    private static StackifyError convert(@NonNull StackifyProto.LogGroup.Log.Error error) {
        if (error == null) {
            throw new NullPointerException("error is marked non-null but is null");
        }
        return StackifyError.newBuilder().environmentDetail(error.hasEnvironmentDetail() ? LogGroupConverter.convert(error.getEnvironmentDetail()) : null).occurredEpochMillis(error.getDateMillis()).error(error.hasErrorItem() ? LogGroupConverter.convert(error.getErrorItem()) : null).webRequestDetail(error.hasWebRequestDetail() ? LogGroupConverter.convert(error.getWebRequestDetail()) : null).serverVariables(error.getServerVariablesMap()).customerName(error.getCustomerName()).userName(error.getUsername()).build();
    }

    private static LogMsg convert(@NonNull StackifyProto.LogGroup.Log log) {
        if (log == null) {
            throw new NullPointerException("log is marked non-null but is null");
        }
        return LogMsg.newBuilder().msg(log.getMessage()).data(log.getData()).ex(log.hasError() ? LogGroupConverter.convert(log.getError()) : null).th(log.getThreadName()).epochMs(log.getDateMillis()).level(log.getLevel()).transId(log.getTransactionId()).srcMethod(log.getSourceMethod()).srcLine(log.getSourceLine()).id(log.getId()).tags((List<String>)log.getTagsList()).build();
    }

    private static Kubernetes convert(@NonNull StackifyProto.LogGroup.Kubernetes kubernetes) {
        if (kubernetes == null) {
            throw new NullPointerException("kubernetes is marked non-null but is null");
        }
        return Kubernetes.newBuilder().podName(kubernetes.getPodName()).podNamespace(kubernetes.getPodNamespace()).clusterName(kubernetes.getClusterName()).build();
    }

    private static Container convert(@NonNull StackifyProto.LogGroup.Container container) {
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        return Container.newBuilder().imageId(container.getImageId()).imageRepository(container.getImageRepository()).imageTag(container.getImageTag()).containerId(container.getContainerId()).containerName(container.getContainerName()).build();
    }

    public static LogMsgGroup convert(@NonNull StackifyProto.LogGroup logGroup) {
        if (logGroup == null) {
            throw new NullPointerException("logGroup is marked non-null but is null");
        }
        LogMsgGroup.Builder builder = LogMsgGroup.newBuilder().env(logGroup.getEnvironment()).serverName(logGroup.getServerName()).appName(logGroup.getApplicationName()).appLoc(logGroup.getApplicationLocation()).logger(logGroup.getLogger()).platform(logGroup.getPlatform());
        if (logGroup.getContainer() != null) {
            builder.container(LogGroupConverter.convert(logGroup.getContainer()));
        }
        if (logGroup.getKubernetes() != null) {
            builder.kubernetes(LogGroupConverter.convert(logGroup.getKubernetes()));
        }
        ArrayList<LogMsg> logMsgs = new ArrayList<LogMsg>();
        if (logGroup.getLogsCount() > 0) {
            for (StackifyProto.LogGroup.Log log : logGroup.getLogsList()) {
                logMsgs.add(LogGroupConverter.convert(log));
            }
            builder.msgs(logMsgs);
        }
        return builder.build();
    }
}

