/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.stackmob.sdk.api.StackMobQueryWithField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StackMobQuery {
    private String objectName;
    private Map<String, String> args = new HashMap<String, String>();

    public StackMobQuery(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Map<String, String> getArguments() {
        return this.args;
    }

    public StackMobQueryWithField field(String field) {
        return new StackMobQueryWithField(field, this);
    }

    public StackMobQuery fieldIsIn(String field, List<String> values) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String val : values) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            builder.append(val);
        }
        this.putInMap(field, Operator.IN, builder.toString());
        return this;
    }

    public StackMobQuery fieldIsLessThan(String field, String val) {
        return this.putInMap(field, Operator.LT, val);
    }

    public StackMobQuery fieldIslessThanOrEqualTo(String field, String val) {
        return this.putInMap(field, Operator.LTE, val);
    }

    public StackMobQuery fieldIsGreaterThan(String field, String val) {
        return this.putInMap(field, Operator.GT, val);
    }

    public StackMobQuery fieldIsGreaterThanOrEqualTo(String field, String val) {
        return this.putInMap(field, Operator.GTE, val);
    }

    public StackMobQuery expandDepthIs(Integer i) {
        this.args.put("_expand", i.toString());
        return this;
    }

    private StackMobQuery putInMap(String field, Operator operator, String value) {
        this.args.put(field + operator.getOperatorForURL(), value);
        return this;
    }

    private StackMobQuery putInMap(String field, Operator operator, int value) {
        this.putInMap(field, operator, Integer.toString(value));
        return this;
    }

    public static enum Operator {
        LT("lt"),
        GT("gt"),
        LTE("lte"),
        GTE("gte"),
        IN("in");

        private String operator;

        private Operator(String operator) {
            this.operator = operator;
        }

        public String getOperatorForURL() {
            return "[" + this.operator + "]";
        }
    }
}

