/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.stackmob.sdk.api.StackMob;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StackMobSession {
    private String key;
    private String secret;
    private String userObjectName;
    private int apiVersionNumber;
    private String appName = null;
    private String lastUserLoginName;
    private long serverTimeDiff = 0L;

    public StackMobSession(String key, String secret, String userObjectName, String appName, int apiVersionNumber) {
        this(key, secret, userObjectName, apiVersionNumber);
        this.appName = appName;
    }

    public StackMobSession(String key, String secret, String userObjectName, int apiVersionNumber) {
        if (key.equals("DEFAULT_API_KEY") || secret.equals("DEFAULT_API_SECRET")) {
            throw new RuntimeException("You forgot to set your api key and secret");
        }
        this.key = key;
        this.secret = secret;
        this.userObjectName = userObjectName;
        this.apiVersionNumber = apiVersionNumber;
    }

    public StackMobSession(StackMobSession that) {
        this.key = that.key;
        this.secret = that.secret;
        this.appName = that.appName;
        this.userObjectName = that.userObjectName;
        this.apiVersionNumber = that.apiVersionNumber;
    }

    public String getKey() {
        return this.key;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getUserObjectName() {
        return this.userObjectName;
    }

    public int getApiVersionNumber() {
        return this.apiVersionNumber;
    }

    public String getAppName() {
        return this.appName;
    }

    protected long getLocalTime() {
        return new Date().getTime() / 1000L;
    }

    public long getServerTime() {
        if (this.getServerTimeDiff() != 0L) {
            StackMob.getLogger().logDebug("Adjusting time for server by %d seconds", this.getServerTimeDiff());
        }
        return this.getServerTimeDiff() + this.getLocalTime();
    }

    public void recordServerTimeDiff(String timeHeader) {
        StackMob.getLogger().logDebug("Got a time header of: %s", timeHeader);
        try {
            long serverTime = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").parse(timeHeader).getTime() / 1000L;
            StackMob.getLogger().logDebug("Got a server time of %d versus local time %d", serverTime, this.getLocalTime());
            this.saveServerTimeDiff(serverTime - this.getLocalTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void saveServerTimeDiff(long serverTimeDiff) {
        this.serverTimeDiff = serverTimeDiff;
    }

    protected long getServerTimeDiff() {
        return this.serverTimeDiff;
    }

    protected void setLastUserLoginName(String username) {
        this.lastUserLoginName = username;
    }

    protected String getLastUserLoginName() {
        return this.lastUserLoginName;
    }
}

